/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.file.JarSearcher;
import me.deecaad.core.utils.LogLevel;
import org.jetbrains.annotations.NotNull;

public class JarInstancer
extends JarSearcher {
    public JarInstancer(@NotNull JarFile jar) {
        super(jar);
    }

    public <T> List<T> createAllInstances(Class<T> clazz, ClassLoader classLoader, boolean isIgnoreAbstract, Class<?> ... classes) {
        List<Class<T>> validClasses = this.findAllSubclasses(clazz, classLoader, isIgnoreAbstract, classes);
        ArrayList<T> instances = new ArrayList<T>();
        for (Class<T> validClass : validClasses) {
            Constructor<T> emptyConstructor;
            try {
                emptyConstructor = validClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                MechanicsCore.debug.log(LogLevel.ERROR, "Found an class implementing " + clazz.getSimpleName() + " class which didn't have empty constructor!", "Please add empty constructor for class " + validClass.getSimpleName());
                continue;
            }
            try {
                T instance = emptyConstructor.newInstance(new Object[0]);
                instances.add(instance);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (instances.isEmpty()) {
            MechanicsCore.debug.warn("Did not instantiate anything? For " + String.valueOf(clazz));
        }
        return instances;
    }
}

