/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.deecaad.core.file.MapConfigLike;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.utils.Keyable;
import me.deecaad.core.utils.StringUtil;
import org.jetbrains.annotations.NotNull;

public interface InlineSerializer<T>
extends Serializer<T>,
Keyable {
    public static final Pattern NAME_FINDER = Pattern.compile(".+?(?=\\{)");
    public static final String UNIQUE_IDENTIFIER = "uniqueIdentifier";

    @Override
    default public boolean shouldSerialize(@NotNull SerializeData data) {
        return false;
    }

    @Override
    @NotNull
    default public String getKey() {
        return this.getInlineKeyword();
    }

    default public String getInlineKeyword() {
        String keyword = this.getKeyword();
        if (keyword == null) {
            String name = this.getClass().getSimpleName();
            throw new NullPointerException("Keyword for " + name + " is null");
        }
        CharSequence[] split = keyword.split("_");
        return String.join((CharSequence)"", split);
    }

    public static Map<String, MapConfigLike.Holder> inlineFormat(String line) throws FormatException {
        int index;
        int trailingWhitespace;
        for (trailingWhitespace = 0; trailingWhitespace < line.length() && line.charAt(trailingWhitespace) == ' '; ++trailingWhitespace) {
        }
        Matcher matcher = NAME_FINDER.matcher(line = line.trim());
        if (!matcher.find()) {
            throw new FormatException(trailingWhitespace, "Could not determine name... Before the first '(' you should have a name like 'Sound'");
        }
        String uniqueIdentifier = matcher.group();
        int squareBrackets = 0;
        int curlyBrackets = 0;
        block7: for (int i = 0; i < line.length(); ++i) {
            if (StringUtil.isEscaped(line, i)) continue;
            switch (line.charAt(i)) {
                case '{': {
                    ++curlyBrackets;
                    continue block7;
                }
                case '}': {
                    --curlyBrackets;
                    continue block7;
                }
                case '[': {
                    ++squareBrackets;
                    continue block7;
                }
                case ']': {
                    --squareBrackets;
                }
            }
        }
        if (curlyBrackets != 0) {
            index = trailingWhitespace + (curlyBrackets > 0 ? InlineSerializer.index(line, '{', 0, line.lastIndexOf(125), 1) : InlineSerializer.index(line, '}', line.length() - 1, line.indexOf(123), -1));
            throw new FormatException(index, "Missing" + (curlyBrackets > 0 ? " closing '}'" : " opening '{'"));
        }
        if (squareBrackets != 0) {
            index = trailingWhitespace + (squareBrackets > 0 ? InlineSerializer.index(line, '[', 0, line.lastIndexOf(93), 1) : InlineSerializer.index(line, ']', line.length() - 1, line.indexOf(91), -1));
            throw new FormatException(index, "Missing" + (squareBrackets > 0 ? " closing ']'" : " opening '['"));
        }
        line = line.substring(uniqueIdentifier.length());
        trailingWhitespace += uniqueIdentifier.length();
        if (line.startsWith("{") && line.endsWith("}")) {
            line = line.substring(1, line.length() - 1);
            ++trailingWhitespace;
        }
        Map<String, MapConfigLike.Holder> map = InlineSerializer.mapify(line, trailingWhitespace);
        map.put(UNIQUE_IDENTIFIER, new MapConfigLike.Holder(uniqueIdentifier.trim(), 0));
        return map;
    }

    public static Map<String, MapConfigLike.Holder> mapify(String line, int offset) throws FormatException {
        HashMap<String, MapConfigLike.Holder> map = new HashMap<String, MapConfigLike.Holder>();
        String key = null;
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (StringUtil.isEscaped(line, i)) {
                if (StringUtil.isEscaped(line, i, true)) {
                    value.append(c);
                }
                if (i + 1 < line.length()) continue;
                if (key == null) {
                    throw new FormatException(offset + i, "Expected key=value, but was missing key... value=" + String.valueOf(value));
                }
                map.put(key, new MapConfigLike.Holder(value.substring(value.indexOf(" ") == 0 ? 1 : 0), i - value.length()));
                continue;
            }
            if (c == '[' || c == '{') {
                int start = i + 1;
                int stop = start + InlineSerializer.findMatch(c, c == '[' ? (char)']' : '}', line.substring(start));
                if (c == '{') {
                    Map<String, MapConfigLike.Holder> tempMap = InlineSerializer.mapify(line.substring(start, stop), start + offset);
                    map.put(key, new MapConfigLike.Holder(tempMap, i));
                    if (!value.toString().isBlank()) {
                        tempMap.put(UNIQUE_IDENTIFIER, new MapConfigLike.Holder(value.toString().trim(), offset + i - value.length()));
                    }
                } else {
                    List<MapConfigLike.Holder> tempList = InlineSerializer.listify(line.substring(start, stop), start + offset);
                    map.put(key, new MapConfigLike.Holder(tempList, offset + i));
                    if (!value.toString().isBlank()) {
                        throw new FormatException(offset + i, "Found '" + String.valueOf(value) + "' before a list... It should not be there!");
                    }
                }
                i = stop;
                key = null;
                value.setLength(0);
                if (i + 1 >= line.length() || line.charAt(i + 1) != ',') continue;
                ++i;
                continue;
            }
            if (c == '=') {
                if (key != null) {
                    throw new FormatException(offset + i, "Found a duplicate '=' after '" + key + "'... Use '\\\\=' for escaped characters.");
                }
                if (value.toString().isBlank()) {
                    throw new FormatException(offset + i, "Found an empty key");
                }
                key = value.toString().trim();
                value.setLength(0);
                continue;
            }
            if (c == ',' || i + 1 == line.length()) {
                if (i + 1 == line.length() && c != ',') {
                    value.append(c);
                }
                if (key == null) {
                    throw new FormatException(offset + i - value.length(), "Expected key=value, but was missing key... fond '" + String.valueOf(value) + "'");
                }
                if (value.isEmpty()) {
                    throw new FormatException(offset + i, "Found an empty value");
                }
                map.put(key, new MapConfigLike.Holder(value.toString(), offset + i - value.length() + 1));
                key = null;
                value.setLength(0);
                continue;
            }
            value.append(c);
        }
        return map;
    }

    public static List<MapConfigLike.Holder> listify(String line, int offset) throws FormatException {
        ArrayList<MapConfigLike.Holder> list = new ArrayList<MapConfigLike.Holder>();
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (StringUtil.isEscaped(line, i)) {
                if (StringUtil.isEscaped(line, i, true)) {
                    value.append(c);
                }
                if (i + 1 < line.length()) continue;
                list.add(new MapConfigLike.Holder(value.substring(value.indexOf(" ") == 0 ? 1 : 0), offset + i - value.length() + 1));
                continue;
            }
            if (c == '[' || c == '=') {
                throw new FormatException(i + offset, "Illegal character '" + c + "'");
            }
            if (c == '{') {
                int start = i + 1;
                int stop = start + InlineSerializer.findMatch(c, '}', line.substring(start));
                Map<String, MapConfigLike.Holder> map = InlineSerializer.mapify(line.substring(start, stop), offset + stop);
                if (!value.toString().isBlank()) {
                    map.put(UNIQUE_IDENTIFIER, new MapConfigLike.Holder(value.toString().trim(), offset + i - value.length() + 1));
                }
                list.add(new MapConfigLike.Holder(map, offset + i + 1));
                i = stop;
                value.setLength(0);
                if (i + 1 >= line.length() || line.charAt(i + 1) != ',') continue;
                ++i;
                continue;
            }
            if (c == ',' || i + 1 == line.length()) {
                if (i + 1 == line.length() && c != ',') {
                    value.append(c);
                }
                if (value.isEmpty()) {
                    throw new FormatException(i + offset, "Found duplicate commas... Use '\\\\,' for an escaped comma");
                }
                list.add(new MapConfigLike.Holder(value.substring(value.indexOf(" ") == 0 ? 1 : 0), offset + i - value.length() + 1));
                value.setLength(0);
                continue;
            }
            value.append(c);
        }
        return list;
    }

    private static int findMatch(char open, char close, String line) {
        int nested = 0;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (StringUtil.isEscaped(line, i)) continue;
            if (c == open) {
                ++nested;
                continue;
            }
            if (c == close && nested > 0) {
                --nested;
                continue;
            }
            if (c != close || nested != 0) continue;
            return i;
        }
        throw new IllegalArgumentException("Could not find match for '" + open + "' in '" + line + "'");
    }

    private static int index(String str, char c, int start, int stop, int step) {
        for (int i = start; i != stop; i += step) {
            if (StringUtil.isEscaped(str, i) || str.charAt(i) != c) continue;
            return i;
        }
        return stop;
    }

    public static class FormatException
    extends Exception {
        private final int index;

        public FormatException(int index) {
            this.index = index;
        }

        public FormatException(int index, String message) {
            super(message);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

