/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.events;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.deecaad.core.file.IValidator;
import me.deecaad.core.file.Serializer;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class QueueSerializerEvent
extends Event {
    public static final HandlerList HANDLER_LIST = new HandlerList();
    private final JavaPlugin source;
    private final File file;
    private final List<Serializer<?>> serializers;
    private final List<IValidator> validators;

    public QueueSerializerEvent(JavaPlugin source, File file) {
        this.source = source;
        this.file = file;
        this.serializers = new ArrayList();
        this.validators = new ArrayList<IValidator>();
    }

    public JavaPlugin getSource() {
        return this.source;
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public File getFile() {
        return this.file;
    }

    public List<Serializer<?>> getSerializers() {
        return this.serializers;
    }

    public List<IValidator> getValidators() {
        return this.validators;
    }

    public void addSerializers(Serializer<?> ... serializers) {
        this.serializers.addAll(Arrays.asList(serializers));
    }

    public void addSerializers(Collection<Serializer<?>> serializers) {
        this.serializers.addAll(serializers);
    }

    public void addValidators(IValidator ... validators) {
        this.validators.addAll(Arrays.asList(validators));
    }

    public void addValidators(Collection<IValidator> validators) {
        this.validators.addAll(validators);
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

