/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Consumer;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.database.DatabaseType;
import me.deecaad.core.utils.LogLevel;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;

public abstract class Database {
    private final DatabaseType type;

    public Database(DatabaseType type) {
        this.type = type;
    }

    public DatabaseType getType() {
        return this.type;
    }

    public void close(@Nullable Connection connection, @Nullable Statement statement, @Nullable ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                MechanicsCore.debug.log(LogLevel.ERROR, e);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                MechanicsCore.debug.log(LogLevel.ERROR, e);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                MechanicsCore.debug.log(LogLevel.ERROR, e);
            }
        }
    }

    public void executeUpdate(boolean forceSync, final String ... sql) {
        if (sql == null || sql.length == 0) {
            throw new IllegalArgumentException("Empty statement");
        }
        if (forceSync) {
            this.executeUpdate(sql);
            return;
        }
        new BukkitRunnable(){

            public void run() {
                Database.this.executeUpdate(sql);
            }
        }.runTaskAsynchronously((Plugin)MechanicsCore.getPlugin());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate(String ... sql) {
        if (sql.length == 1) {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(sql[0]);
                preparedStatement.executeUpdate();
                this.close(connection, preparedStatement, null);
            }
            catch (SQLException e) {
                try {
                    MechanicsCore.debug.log(LogLevel.ERROR, e);
                    this.close(connection, preparedStatement, null);
                }
                catch (Throwable throwable) {
                    this.close(connection, preparedStatement, null);
                    throw throwable;
                }
            }
            return;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.createStatement();
            connection.setAutoCommit(false);
            for (String sqlStatement : sql) {
                statement.addBatch(sqlStatement);
            }
            statement.executeBatch();
            connection.commit();
            connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            MechanicsCore.debug.log(LogLevel.ERROR, e);
        }
        finally {
            this.close(connection, statement, null);
        }
    }

    public void executeQuery(final String sql, final Consumer<ResultSet> consumer) {
        if (sql == null || sql.isEmpty() || consumer == null) {
            throw new IllegalArgumentException("Empty statement or null consumer");
        }
        new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    connection = Database.this.getConnection();
                    preparedStatement = connection.prepareStatement(sql);
                    resultSet = preparedStatement.executeQuery();
                    consumer.accept(resultSet);
                    Database.this.close(connection, preparedStatement, resultSet);
                }
                catch (SQLException e) {
                    try {
                        MechanicsCore.debug.log(LogLevel.ERROR, e);
                        Database.this.close(connection, preparedStatement, resultSet);
                    }
                    catch (Throwable throwable) {
                        Database.this.close(connection, preparedStatement, resultSet);
                        throw throwable;
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)MechanicsCore.getPlugin());
    }

    public void printResultSet(ResultSet rs) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnsNumber = rsmd.getColumnCount();
            StringBuilder builder = new StringBuilder();
            while (rs.next()) {
                for (int i = 1; i <= columnsNumber; ++i) {
                    builder.append(" | ").append(rs.getString(i));
                }
                builder.append(System.lineSeparator());
            }
            MechanicsCore.debug.log(LogLevel.DEBUG, builder.toString());
        }
        catch (SQLException e) {
            MechanicsCore.debug.log(LogLevel.ERROR, e);
        }
    }

    public abstract Connection getConnection() throws SQLException;

    public abstract void close() throws SQLException;

    public abstract boolean isClosed();
}

