/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.compatibility.nbt;

import me.deecaad.core.compatibility.nbt.NBTCompatibility;
import me.deecaad.core.compatibility.nbt.StringPersistentType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public abstract class NBT_Persistent
implements NBTCompatibility {
    @Override
    public boolean hasString(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key) {
        return this.getCompound(bukkitItem.getItemMeta()).has(this.getKey(plugin, key), PersistentDataType.STRING);
    }

    @Override
    public String getString(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key, String def) {
        ItemMeta meta = bukkitItem.getItemMeta();
        PersistentDataContainer nbt = this.getCompound(meta);
        return (String)nbt.getOrDefault(this.getKey(plugin, key), PersistentDataType.STRING, (Object)def);
    }

    @Override
    public void setString(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key, String value) {
        ItemMeta meta = bukkitItem.getItemMeta();
        PersistentDataContainer nbt = this.getCompound(meta);
        nbt.set(this.getKey(plugin, key), PersistentDataType.STRING, (Object)value);
        bukkitItem.setItemMeta(meta);
    }

    @Override
    public boolean hasInt(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key) {
        return this.getCompound(bukkitItem.getItemMeta()).has(this.getKey(plugin, key), PersistentDataType.INTEGER);
    }

    @Override
    public int getInt(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key, int def) {
        ItemMeta meta = bukkitItem.getItemMeta();
        PersistentDataContainer nbt = this.getCompound(meta);
        return (Integer)nbt.getOrDefault(this.getKey(plugin, key), PersistentDataType.INTEGER, (Object)def);
    }

    @Override
    public void setInt(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key, int value) {
        ItemMeta meta = bukkitItem.getItemMeta();
        PersistentDataContainer nbt = this.getCompound(meta);
        nbt.set(this.getKey(plugin, key), PersistentDataType.INTEGER, (Object)value);
        bukkitItem.setItemMeta(meta);
    }

    @Override
    public boolean hasDouble(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key) {
        return this.getCompound(bukkitItem.getItemMeta()).has(this.getKey(plugin, key), PersistentDataType.DOUBLE);
    }

    @Override
    public double getDouble(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key, double def) {
        ItemMeta meta = bukkitItem.getItemMeta();
        PersistentDataContainer nbt = this.getCompound(meta);
        return (Double)nbt.getOrDefault(this.getKey(plugin, key), PersistentDataType.DOUBLE, (Object)def);
    }

    @Override
    public void setDouble(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key, double value) {
        ItemMeta meta = bukkitItem.getItemMeta();
        PersistentDataContainer nbt = this.getCompound(meta);
        nbt.set(this.getKey(plugin, key), PersistentDataType.DOUBLE, (Object)value);
        bukkitItem.setItemMeta(meta);
    }

    @Override
    public boolean hasArray(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key) {
        return this.getCompound(bukkitItem.getItemMeta()).has(this.getKey(plugin, key), PersistentDataType.INTEGER_ARRAY);
    }

    @Override
    public int[] getArray(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key, int[] def) {
        ItemMeta meta = bukkitItem.getItemMeta();
        PersistentDataContainer nbt = this.getCompound(meta);
        return nbt.has(this.getKey(plugin, key), PersistentDataType.INTEGER_ARRAY) ? (int[])nbt.get(this.getKey(plugin, key), PersistentDataType.INTEGER_ARRAY) : def;
    }

    @Override
    public void setArray(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key, int[] value) {
        ItemMeta meta = bukkitItem.getItemMeta();
        PersistentDataContainer nbt = this.getCompound(meta);
        nbt.set(this.getKey(plugin, key), PersistentDataType.INTEGER_ARRAY, (Object)value);
        bukkitItem.setItemMeta(meta);
    }

    @Override
    public boolean hasStringArray(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key) {
        return this.getCompound(bukkitItem.getItemMeta()).has(this.getKey(plugin, key), (PersistentDataType)StringPersistentType.INSTANCE);
    }

    @Override
    public String[] getStringArray(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key, String[] def) {
        ItemMeta meta = bukkitItem.getItemMeta();
        PersistentDataContainer nbt = this.getCompound(meta);
        return nbt.has(this.getKey(plugin, key), (PersistentDataType)StringPersistentType.INSTANCE) ? (String[])nbt.get(this.getKey(plugin, key), (PersistentDataType)StringPersistentType.INSTANCE) : def;
    }

    @Override
    public void setStringArray(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key, String[] value) {
        ItemMeta meta = bukkitItem.getItemMeta();
        PersistentDataContainer nbt = this.getCompound(meta);
        nbt.set(this.getKey(plugin, key), (PersistentDataType)StringPersistentType.INSTANCE, (Object)value);
        bukkitItem.setItemMeta(meta);
    }

    @Override
    public void remove(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key) {
        ItemMeta meta = bukkitItem.getItemMeta();
        PersistentDataContainer nbt = this.getCompound(meta);
        nbt.remove(this.getKey(plugin, key));
        bukkitItem.setItemMeta(meta);
    }

    private PersistentDataContainer getCompound(@NotNull ItemMeta meta) {
        return meta.getPersistentDataContainer();
    }
}

