/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.compatibility.nbt;

import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import me.deecaad.core.utils.AttributeType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface NBTCompatibility {
    public static final int[] DO_NOT_MODIFY_ME = new int[0];
    public static final String[] DO_NOT_MODIFY_ME_STRING = new String[0];

    public boolean hasString(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3);

    default public String getString(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key) {
        return this.getString(bukkitItem, plugin, key, null);
    }

    public String getString(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3, String var4);

    public void setString(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3, String var4);

    public boolean hasInt(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3);

    default public int getInt(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key) {
        return this.getInt(bukkitItem, plugin, key, 0);
    }

    public int getInt(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3, int var4);

    public void setInt(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3, int var4);

    public boolean hasDouble(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3);

    default public double getDouble(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key) {
        return this.getDouble(bukkitItem, plugin, key, 0.0);
    }

    public double getDouble(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3, double var4);

    public void setDouble(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3, double var4);

    public boolean hasArray(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3);

    default public int[] getArray(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key) {
        return this.getArray(bukkitItem, plugin, key, DO_NOT_MODIFY_ME);
    }

    public int[] getArray(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3, int[] var4);

    public void setArray(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3, int[] var4);

    public boolean hasStringArray(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3);

    default public String[] getStringArray(@NotNull ItemStack bukkitItem, @NotNull String plugin, @NotNull String key) {
        return this.getStringArray(bukkitItem, plugin, key, DO_NOT_MODIFY_ME_STRING);
    }

    public String[] getStringArray(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3, String[] var4);

    public void setStringArray(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3, String[] var4);

    public void remove(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3);

    default public double getAttributeValue(@NotNull ItemStack bukkitItem, @NotNull AttributeType attribute, @Nullable AttributeSlot slot) {
        ItemMeta meta = bukkitItem.getItemMeta();
        if (meta == null) {
            return 0.0;
        }
        Attribute bukkitAttribute = Attribute.valueOf((String)attribute.name());
        Collection modifiers = meta.getAttributeModifiers(bukkitAttribute);
        if (modifiers == null) {
            return 0.0;
        }
        double value = 0.0;
        for (AttributeModifier modifier : modifiers) {
            if (slot != null && modifier.getSlot() != null && modifier.getSlot() != slot.getEquipmentSlot()) continue;
            switch (modifier.getOperation()) {
                case ADD_NUMBER: {
                    value += modifier.getAmount();
                    break;
                }
                case ADD_SCALAR: {
                    value += value * modifier.getAmount();
                    break;
                }
                case MULTIPLY_SCALAR_1: {
                    value *= modifier.getAmount();
                }
            }
        }
        return value;
    }

    @Nullable
    default public AttributeModifier getAttribute(@NotNull ItemStack bukkitItem, @NotNull AttributeType attribute, @Nullable AttributeSlot slot) {
        ItemMeta meta = bukkitItem.getItemMeta();
        Attribute bukkitAttribute = Attribute.valueOf((String)attribute.name());
        UUID uuid = slot == null ? attribute.getUUID() : slot.modify(attribute.getUUID());
        for (AttributeModifier existingModifier : meta.getAttributeModifiers(bukkitAttribute)) {
            if (!uuid.equals(existingModifier.getUniqueId())) continue;
            return existingModifier;
        }
        return null;
    }

    default public void setAttribute(@NotNull ItemStack bukkitItem, @NotNull AttributeType attribute, @Nullable AttributeSlot slot, double value) {
        ItemMeta meta = bukkitItem.getItemMeta();
        Attribute bukkitAttribute = Attribute.valueOf((String)attribute.name());
        AttributeModifier hand = new AttributeModifier(slot == null ? attribute.getUUID() : slot.modify(attribute.getUUID()), "MechanicsCoreAttribute", value, AttributeModifier.Operation.ADD_NUMBER, slot == null ? null : slot.getEquipmentSlot());
        meta.removeAttributeModifier(bukkitAttribute, hand);
        meta.addAttributeModifier(bukkitAttribute, hand);
        bukkitItem.setItemMeta(meta);
    }

    default public NamespacedKey getKey(String plugin, String key) {
        return new NamespacedKey(plugin.toLowerCase(Locale.ROOT), key.toLowerCase(Locale.ROOT));
    }

    public void copyTagsFromTo(@NotNull ItemStack var1, @NotNull ItemStack var2, String var3);

    @NotNull
    public Object getNMSStack(@NotNull ItemStack var1);

    @NotNull
    public ItemStack getBukkitStack(@NotNull Object var1);

    @NotNull
    public String getNBTDebug(@NotNull ItemStack var1);

    @NotNull
    default public Component getDisplayName(@NotNull ItemStack item) {
        String legacyText = item.getItemMeta().getDisplayName();
        return LegacyComponentSerializer.legacySection().deserialize(legacyText);
    }

    public static enum AttributeSlot {
        MAIN_HAND(1L),
        OFF_HAND(6L),
        FEET(5L),
        LEGS(4L),
        CHEST(3L),
        HEAD(2L),
        BODY(7L);

        private final EquipmentSlot slot = this.name().equals("MAIN_HAND") ? EquipmentSlot.HAND : EquipmentSlot.valueOf((String)this.name());
        private final String slotName = this.name().replaceAll("_", "").toLowerCase(Locale.ROOT);
        private final long uuidModifier;

        private AttributeSlot(long uuidModifier) {
            this.uuidModifier = uuidModifier;
        }

        public EquipmentSlot getEquipmentSlot() {
            return this.slot;
        }

        public String getSlotName() {
            return this.slotName;
        }

        public UUID modify(UUID uuid) {
            return new UUID(uuid.getMostSignificantBits() + this.uuidModifier, uuid.getLeastSignificantBits());
        }

        public String toString() {
            return "AttributeSlot{slot=" + String.valueOf(this.slot) + ", slotName='" + this.slotName + "'}";
        }
    }
}

