/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.compatibility.entity;

import java.util.HashMap;
import java.util.Map;
import me.deecaad.core.utils.NumberUtil;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FakeEntity {
    public static final int FIRE_FLAG = 0;
    public static final int SNEAKING_FLAG = 1;
    public static final int SPRINTING_FLAG = 3;
    public static final int SWIMMING_FLAG = 4;
    public static final int INVISIBLE_FLAG = 5;
    public static final int GLOWING_FLAG = 6;
    public static final int GLIDING_FLAG = 7;
    private static Map<String, Integer> OBJECT_REGISTRY;
    protected final EntityType type;
    protected Location location;
    protected Location offset;
    protected Vector motion;
    protected int cache = -1;

    public FakeEntity(@NotNull Location location, @NotNull EntityType type) {
        this.type = type;
        this.location = new Location(location.getWorld(), 0.0, 0.0, 0.0);
        this.motion = new Vector();
    }

    public EntityType getType() {
        return this.type;
    }

    public final boolean isOnFire() {
        return this.getMeta(0);
    }

    public final boolean isGlowing() {
        return this.getMeta(6);
    }

    public final boolean isInvisible() {
        return this.getMeta(5);
    }

    public abstract boolean getMeta(int var1);

    public final void setOnFire(boolean isOnFire) {
        this.setMeta(0, isOnFire);
    }

    public final void setGlowing(boolean isGlowing) {
        this.setMeta(6, isGlowing);
    }

    public final void setInvisible(boolean isInvisible) {
        this.setMeta(5, isInvisible);
    }

    public abstract void setMeta(int var1, boolean var2);

    @Nullable
    public abstract Object getData();

    public abstract void setData(@Nullable Object var1);

    public abstract void setDisplay(@Nullable String var1);

    public abstract void setGravity(boolean var1);

    public double getX() {
        return this.location.getX();
    }

    public double getY() {
        return this.location.getY();
    }

    public double getZ() {
        return this.location.getZ();
    }

    public float getYaw() {
        return this.location.getYaw();
    }

    public float getPitch() {
        return this.location.getPitch();
    }

    public void setOffset(Location offset) {
        this.offset = offset;
    }

    protected void setLocation(double x, double y, double z, float yaw, float pitch) {
        this.location.setX(x);
        this.location.setY(y);
        this.location.setZ(z);
        this.location.setYaw(yaw);
        this.location.setPitch(pitch);
    }

    public final void setMotion(@NotNull Vector motion) {
        this.setMotion(motion.getX(), motion.getY(), motion.getZ());
    }

    public abstract void setMotion(double var1, double var3, double var5);

    public abstract void setRotation(float var1, float var2);

    public final void setPosition(@NotNull Vector pos, float yaw, float pitch) {
        this.setPosition(pos.getX(), pos.getY(), pos.getZ(), yaw, pitch, false);
    }

    public final void setPosition(double x, double y, double z) {
        this.setPosition(x, y, z, this.getYaw(), this.getPitch(), false);
    }

    public final void setPosition(double x, double y, double z, float yaw, float pitch) {
        this.setPosition(x, y, z, yaw, pitch, false);
    }

    public final void setPosition(double x, double y, double z, float yaw, float pitch, boolean raw) {
        double lengthSquared;
        if (this.offset != null) {
            x += this.offset.getX();
            y += this.offset.getY();
            z += this.offset.getZ();
            yaw += this.offset.getYaw();
            pitch += this.offset.getPitch();
        }
        double d = lengthSquared = raw ? 0.0 : NumberUtil.square(x - this.location.getX()) + NumberUtil.square(y - this.location.getY()) + NumberUtil.square(z - this.location.getZ());
        if (raw || lengthSquared == 0.0 || lengthSquared > 64.0) {
            this.setLocation(x, y, z, yaw, pitch);
            this.setPositionRaw(x, y, z, yaw, pitch);
        } else {
            this.setPositionRotation(x - this.location.getX(), y - this.location.getY(), z - this.location.getZ(), yaw, pitch);
            this.setLocation(x, y, z, yaw, pitch);
        }
        if (this.type == EntityType.ARMOR_STAND) {
            this.updateMeta();
        }
    }

    private void setPositionRotation(double dx, double dy, double dz, float yaw, float pitch) {
        this.setPositionRotation((short)(dx * 4096.0), (short)(dy * 4096.0), (short)(dz * 4096.0), this.convertYaw(yaw), this.convertPitch(pitch));
    }

    protected abstract void setPositionRotation(short var1, short var2, short var3, byte var4, byte var5);

    protected abstract void setPositionRaw(double var1, double var3, double var5, float var7, float var8);

    protected final byte convertPitch(float degrees) {
        degrees *= 0.7111111f;
        if (!this.type.isAlive()) {
            return (byte)(-degrees);
        }
        return (byte)degrees;
    }

    protected final byte convertYaw(float degrees) {
        degrees *= 0.7111111f;
        return switch (this.type) {
            case EntityType.ARROW -> (byte)(-degrees);
            case EntityType.WITHER_SKULL, EntityType.ENDER_DRAGON -> (byte)(degrees - 128.0f);
            default -> !this.type.isAlive() && this.type != EntityType.ARMOR_STAND ? (byte)(degrees - 64.0f) : (byte)degrees;
        };
    }

    public abstract void show();

    public abstract void show(@NotNull Player var1);

    public abstract void updateMeta();

    public abstract void remove();

    public abstract void remove(@NotNull Player var1);

    public abstract void playEffect(@NotNull EntityEffect var1);

    public abstract void setEquipment(@NotNull EquipmentSlot var1, @Nullable ItemStack var2);

    public abstract void updateEquipment();

    protected int getSpawnId() {
        if (OBJECT_REGISTRY == null) {
            OBJECT_REGISTRY = new HashMap<String, Integer>();
            OBJECT_REGISTRY.put("BOAT", 1);
            OBJECT_REGISTRY.put("DROPPED_ITEM", 2);
            OBJECT_REGISTRY.put("AREA_EFFECT_CLOUD", 3);
            OBJECT_REGISTRY.put("PRIMED_TNT", 50);
            OBJECT_REGISTRY.put("ENDER_CRYSTAL", 51);
            OBJECT_REGISTRY.put("ARROW", 60);
            OBJECT_REGISTRY.put("SNOWBALL", 61);
            OBJECT_REGISTRY.put("EGG", 62);
            OBJECT_REGISTRY.put("FIREBALL", 63);
            OBJECT_REGISTRY.put("SMALL_FIREBALL", 64);
            OBJECT_REGISTRY.put("ENDER_PEARL", 65);
            OBJECT_REGISTRY.put("WITHER_SKULL", 66);
            OBJECT_REGISTRY.put("SHULKER_BULLET", 67);
            OBJECT_REGISTRY.put("LLAMA_SPIT", 68);
            OBJECT_REGISTRY.put("FALLING_BLOCK", 70);
            OBJECT_REGISTRY.put("ENDER_SIGNAL", 72);
            OBJECT_REGISTRY.put("SPLASH_POTION", 73);
            OBJECT_REGISTRY.put("THROWN_EXP_BOTTLE", 75);
            OBJECT_REGISTRY.put("FIREWORK", 76);
            OBJECT_REGISTRY.put("ARMOR_STAND", 78);
            OBJECT_REGISTRY.put("EVOKER_FANGS", 79);
            OBJECT_REGISTRY.put("SPECTRAL_ARROW", 91);
            OBJECT_REGISTRY.put("DRAGON_FIREBALL", 93);
            OBJECT_REGISTRY.put("TRIDENT", 94);
        }
        return OBJECT_REGISTRY.get(this.type.name());
    }
}

