/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.compatibility.block;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import me.deecaad.core.compatibility.HitBox;
import org.bukkit.Sound;
import org.bukkit.SoundGroup;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BlockCompatibility {
    public static final AtomicInteger IDS = new AtomicInteger(0);

    @Nullable
    default public HitBox getHitBox(@NotNull Block block) {
        return this.getHitBox(block, false);
    }

    @Nullable
    default public HitBox getHitBox(@NotNull Block block, boolean allowLiquid) {
        HitBox hitBox;
        if (!block.getChunk().isLoaded()) {
            return null;
        }
        if (block.isEmpty()) {
            return null;
        }
        boolean isLiquid = block.isLiquid();
        if (!allowLiquid ? block.isPassable() || block.isLiquid() : !isLiquid && block.isPassable()) {
            return null;
        }
        if (isLiquid) {
            hitBox = new HitBox(block.getX(), block.getY(), block.getZ(), block.getX() + 1, block.getY() + 1, block.getZ() + 1);
        } else {
            BoundingBox boundingBox = block.getBoundingBox();
            hitBox = new HitBox(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        }
        hitBox.setBlockHitBox(block);
        Collection voxelShape = block.getCollisionShape().getBoundingBoxes();
        if (voxelShape.size() > 1) {
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            for (BoundingBox boxPart : voxelShape) {
                hitBox.addVoxelShapePart(new HitBox((double)x + boxPart.getMinX(), (double)y + boxPart.getMinY(), (double)z + boxPart.getMinZ(), (double)x + boxPart.getMaxX(), (double)y + boxPart.getMaxY(), (double)z + boxPart.getMaxZ()));
            }
        }
        return hitBox;
    }

    @NotNull
    public Object getCrackPacket(@NotNull Block var1, int var2);

    @NotNull
    public Object getCrackPacket(@NotNull Block var1, int var2, int var3);

    default public SoundData getBlockSound(Object blockData, SoundType type) {
        BlockData data = (BlockData)blockData;
        SoundGroup sounds = data.getSoundGroup();
        SoundData soundData = new SoundData();
        soundData.type = type;
        soundData.pitch = sounds.getPitch();
        soundData.volume = sounds.getVolume();
        soundData.sound = switch (type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> sounds.getBreakSound();
            case 1 -> sounds.getStepSound();
            case 2 -> sounds.getPlaceSound();
            case 3 -> sounds.getHitSound();
            case 4 -> sounds.getFallSound();
        };
        return soundData;
    }

    default public float getBlastResistance(Block block) {
        return block.getType().getBlastResistance();
    }

    public static class SoundData {
        public SoundType type;
        public Sound sound;
        public float volume;
        public float pitch;
    }

    public static enum SoundType {
        BREAK,
        STEP,
        PLACE,
        HIT,
        FALL;

    }
}

