/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.compatibility;

import java.util.ArrayList;
import java.util.Collection;
import me.deecaad.core.file.serializers.ColorSerializer;
import me.deecaad.core.utils.MinecraftVersions;
import me.deecaad.core.utils.ray.BlockTraceResult;
import me.deecaad.core.utils.ray.EntityTraceResult;
import me.deecaad.core.utils.ray.RayTraceResult;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class HitBox {
    private static final Particle DUST_PARTICLE = MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast() ? Particle.DUST : Particle.valueOf((String)"REDSTONE");
    private Block block;
    private LivingEntity livingEntity;
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;
    private Collection<HitBox> voxelShape;

    public HitBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.modify(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public HitBox(Vector start, Vector end) {
        this(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ());
    }

    public HitBox modify(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = Math.min(minX, maxX);
        this.minY = Math.min(minY, maxY);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxY = Math.max(minY, maxY);
        this.maxZ = Math.max(minZ, maxZ);
        return this;
    }

    public void setBlockHitBox(Block block) {
        if (this.livingEntity != null) {
            throw new IllegalArgumentException("Can't set living entity for block hitbox");
        }
        this.block = block;
    }

    public void setLivingEntity(LivingEntity livingEntity) {
        if (this.block != null) {
            throw new IllegalArgumentException("Can't set block for living entity hitbox");
        }
        this.livingEntity = livingEntity;
    }

    public void addVoxelShapePart(HitBox hitBox) {
        if (this.voxelShape == null) {
            this.voxelShape = new ArrayList<HitBox>(2);
        }
        this.voxelShape.add(hitBox);
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getDepth() {
        return this.maxZ - this.minZ;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public double getCenterX() {
        return this.minX + this.getWidth() * 0.5;
    }

    public double getCenterY() {
        return this.minY + this.getHeight() * 0.5;
    }

    public double getCenterZ() {
        return this.minZ + this.getDepth() * 0.5;
    }

    public Vector getMin() {
        return new Vector(this.minX, this.minY, this.minZ);
    }

    public Vector getMax() {
        return new Vector(this.maxX, this.maxY, this.maxZ);
    }

    public boolean collides(Vector point) {
        if (point == null) {
            return false;
        }
        return point.getX() >= this.minX && point.getX() <= this.maxX && point.getY() >= this.minY && point.getY() <= this.maxY && point.getZ() >= this.minZ && point.getZ() <= this.maxZ;
    }

    public boolean overlaps(HitBox other) {
        return this.minX < other.maxX && this.maxX > other.minX && this.minY < other.maxY && this.maxY > other.minY && this.minZ < other.maxZ && this.maxZ > other.minZ;
    }

    public HitBox grow(double amount) {
        if (amount == 0.0) {
            return this;
        }
        return this.modify(this.minX - amount, this.minY - amount, this.minZ - amount, this.maxX + amount, this.maxY + amount, this.maxZ + amount);
    }

    public HitBox grow(double width, double height) {
        return this.modify(this.minX - (width /= 2.0), this.minY, this.minZ - width, this.maxX + width, this.maxY + height, this.maxZ + width);
    }

    public HitBox expand(Vector direction, double expansion) {
        double dirX = direction.getX();
        double dirY = direction.getY();
        double dirZ = direction.getZ();
        if (dirX == 0.0 && dirY == 0.0 && dirZ == 0.0) {
            return this;
        }
        double negativeX = dirX < 0.0 ? -dirX * expansion : 0.0;
        double negativeY = dirY < 0.0 ? -dirY * expansion : 0.0;
        double negativeZ = dirZ < 0.0 ? -dirZ * expansion : 0.0;
        double positiveX = dirX > 0.0 ? dirX * expansion : 0.0;
        double positiveY = dirY > 0.0 ? dirY * expansion : 0.0;
        double positiveZ = dirZ > 0.0 ? dirZ * expansion : 0.0;
        return this.expand(negativeX, negativeY, negativeZ, positiveX, positiveY, positiveZ);
    }

    public HitBox expand(double negativeX, double negativeY, double negativeZ, double positiveX, double positiveY, double positiveZ) {
        double centerZ;
        double newMinX = this.minX - negativeX;
        double newMinY = this.minY - negativeY;
        double newMinZ = this.minZ - negativeZ;
        double newMaxX = this.maxX + positiveX;
        double newMaxY = this.maxY + positiveY;
        double newMaxZ = this.maxZ + positiveZ;
        if (newMinX > newMaxX) {
            centerZ = this.getCenterX();
            if (newMaxX >= centerZ) {
                newMinX = newMaxX;
            } else if (newMinX <= centerZ) {
                newMaxX = newMinX;
            } else {
                newMinX = centerZ;
                newMaxX = centerZ;
            }
        }
        if (newMinY > newMaxY) {
            centerZ = this.getCenterY();
            if (newMaxY >= centerZ) {
                newMinY = newMaxY;
            } else if (newMinY <= centerZ) {
                newMaxY = newMinY;
            } else {
                newMinY = centerZ;
                newMaxY = centerZ;
            }
        }
        if (newMinZ > newMaxZ) {
            centerZ = this.getCenterZ();
            if (newMaxZ >= centerZ) {
                newMinZ = newMaxZ;
            } else if (newMinZ <= centerZ) {
                newMaxZ = newMinZ;
            } else {
                newMinZ = centerZ;
                newMaxZ = centerZ;
            }
        }
        return this.modify(newMinX, newMinY, newMinZ, newMaxX, newMaxY, newMaxZ);
    }

    public RayTraceResult rayTrace(Vector location, Vector normalizedMotion) {
        RayTraceResult mainBoxHit = this.ray(location, normalizedMotion);
        if (this.voxelShape == null || mainBoxHit == null) {
            return mainBoxHit;
        }
        RayTraceResult hit = null;
        double closestHit = -1.0;
        for (HitBox boxPart : this.voxelShape) {
            RayTraceResult boxPartHit;
            if (mainBoxHit instanceof BlockTraceResult) {
                BlockTraceResult blockHit = (BlockTraceResult)mainBoxHit;
                boxPart.setBlockHitBox(blockHit.getBlock());
            } else if (mainBoxHit instanceof EntityTraceResult) {
                EntityTraceResult entityHit = (EntityTraceResult)mainBoxHit;
                boxPart.setLivingEntity(entityHit.getEntity());
            }
            if ((boxPartHit = boxPart.ray(location, normalizedMotion)) == null || closestHit != -1.0 && !(boxPartHit.getHitMin() < closestHit)) continue;
            closestHit = boxPartHit.getHitMin();
            hit = boxPartHit;
        }
        return hit;
    }

    private RayTraceResult ray(Vector location, Vector normalizedMotion) {
        BlockFace hitBlockFaceZMax;
        BlockFace hitBlockFaceZMin;
        double tzMax;
        double tzMin;
        BlockFace hitBlockFaceYMax;
        BlockFace hitBlockFaceYMin;
        double tyMax;
        double tyMin;
        BlockFace hitBlockFaceMax;
        BlockFace hitBlockFaceMin;
        double tMax;
        double tMin;
        double startX = location.getX();
        double startY = location.getY();
        double startZ = location.getZ();
        double dirX = normalizedMotion.getX();
        double dirY = normalizedMotion.getY();
        double dirZ = normalizedMotion.getZ();
        double divX = 1.0 / dirX;
        double divY = 1.0 / dirY;
        double divZ = 1.0 / dirZ;
        if (dirX >= 0.0) {
            tMin = (this.minX - startX) * divX;
            tMax = (this.maxX - startX) * divX;
            hitBlockFaceMin = BlockFace.WEST;
            hitBlockFaceMax = BlockFace.EAST;
        } else {
            tMin = (this.maxX - startX) * divX;
            tMax = (this.minX - startX) * divX;
            hitBlockFaceMin = BlockFace.EAST;
            hitBlockFaceMax = BlockFace.WEST;
        }
        if (dirY >= 0.0) {
            tyMin = (this.minY - startY) * divY;
            tyMax = (this.maxY - startY) * divY;
            hitBlockFaceYMin = BlockFace.DOWN;
            hitBlockFaceYMax = BlockFace.UP;
        } else {
            tyMin = (this.maxY - startY) * divY;
            tyMax = (this.minY - startY) * divY;
            hitBlockFaceYMin = BlockFace.UP;
            hitBlockFaceYMax = BlockFace.DOWN;
        }
        if (tMin > tyMax || tMax < tyMin) {
            return null;
        }
        if (tyMin > tMin) {
            tMin = tyMin;
            hitBlockFaceMin = hitBlockFaceYMin;
        }
        if (tyMax < tMax) {
            tMax = tyMax;
            hitBlockFaceMax = hitBlockFaceYMax;
        }
        if (dirZ >= 0.0) {
            tzMin = (this.minZ - startZ) * divZ;
            tzMax = (this.maxZ - startZ) * divZ;
            hitBlockFaceZMin = BlockFace.NORTH;
            hitBlockFaceZMax = BlockFace.SOUTH;
        } else {
            tzMin = (this.maxZ - startZ) * divZ;
            tzMax = (this.minZ - startZ) * divZ;
            hitBlockFaceZMin = BlockFace.SOUTH;
            hitBlockFaceZMax = BlockFace.NORTH;
        }
        if (tMin > tzMax || tMax < tzMin) {
            return null;
        }
        if (tzMin > tMin) {
            tMin = tzMin;
            hitBlockFaceMin = hitBlockFaceZMin;
        }
        if (tzMax < tMax) {
            tMax = tzMax;
            hitBlockFaceMax = hitBlockFaceZMax;
        }
        if (tMax < 0.0) {
            return null;
        }
        if (this.block != null) {
            return new BlockTraceResult(location, normalizedMotion, this, hitBlockFaceMin, hitBlockFaceMax, tMin, tMax, this.block);
        }
        if (this.livingEntity == null) {
            return new RayTraceResult(location, normalizedMotion, this, hitBlockFaceMin, hitBlockFaceMax, tMin, tMax);
        }
        return new EntityTraceResult(location, normalizedMotion, this, hitBlockFaceMin, hitBlockFaceMax, tMin, tMax, this.livingEntity);
    }

    public void outlineAllBoxes(Entity player) {
        if (this.voxelShape != null) {
            this.outlineMainBox(player, Color.BLACK);
            ColorSerializer.ColorType[] colors = ColorSerializer.ColorType.values();
            int i = 1;
            for (HitBox voxel : this.voxelShape) {
                voxel.outlineMainBox(player, colors[i].getBukkitColor());
                if (++i < colors.length) continue;
                i = 1;
            }
        } else {
            this.outlineMainBox(player, Color.BLACK);
        }
    }

    public void outlineMainBox(Entity player, Color color) {
        double step = 0.05;
        for (double x = this.minX; x <= this.maxX; x += step) {
            for (double y = this.minY; y <= this.maxY; y += step) {
                for (double z = this.minZ; z <= this.maxZ; z += step) {
                    int components = 0;
                    if (x == this.minX || x + step > this.maxX) {
                        ++components;
                    }
                    if (y == this.minY || y + step > this.maxY) {
                        ++components;
                    }
                    if (z == this.minZ || z + step > this.maxZ) {
                        ++components;
                    }
                    if (components < 2) continue;
                    if (!MinecraftVersions.UPDATE_AQUATIC.isAtLeast()) {
                        player.getWorld().spawnParticle(Particle.CRIT, x, y, z, 1, 0.0, 0.0, 0.0, 1.0E-4);
                        continue;
                    }
                    player.getWorld().spawnParticle(DUST_PARTICLE, x, y, z, 1, 0.0, 0.0, 0.0, 1.0E-4, (Object)new Particle.DustOptions(color, 0.5f), true);
                }
            }
        }
    }

    public HitBox cloneDimensions() {
        return new HitBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

