/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.compatibility;

import me.deecaad.core.utils.MinecraftVersions;
import me.deecaad.core.utils.ReflectionUtil;
import org.jetbrains.annotations.Nullable;

public class CompatibilitySetup {
    public String getVersionAsString() {
        return MinecraftVersions.getCURRENT().toProtocolString();
    }

    @Nullable
    public <T> T getCompatibleVersion(Class<T> interfaceClazz, String directory) {
        String version = this.getVersionAsString();
        try {
            Class<?> compatibilityClass = Class.forName(directory + "." + version, false, interfaceClazz.getClassLoader());
            Object compatibility = ReflectionUtil.newInstance(ReflectionUtil.getConstructor(compatibilityClass, new Class[0]), new Object[0]);
            return compatibility != null ? (T)interfaceClazz.cast(compatibility) : null;
        }
        catch (ClassCastException | ClassNotFoundException exception) {
            return null;
        }
    }
}

