/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.compatibility;

import java.lang.reflect.Constructor;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.compatibility.CompatibilitySetup;
import me.deecaad.core.compatibility.ICompatibility;
import me.deecaad.core.compatibility.block.BlockCompatibility;
import me.deecaad.core.compatibility.command.CommandCompatibility;
import me.deecaad.core.compatibility.entity.EntityCompatibility;
import me.deecaad.core.compatibility.nbt.NBTCompatibility;
import me.deecaad.core.compatibility.vault.IVaultCompatibility;
import me.deecaad.core.compatibility.worldguard.NoWorldGuard;
import me.deecaad.core.compatibility.worldguard.WorldGuardCompatibility;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.MinecraftVersions;
import me.deecaad.core.utils.ReflectionUtil;
import org.bukkit.Bukkit;

public final class CompatibilityAPI {
    private static ICompatibility compatibility;
    private static WorldGuardCompatibility worldGuardCompatibility;
    private static IVaultCompatibility vaultCompatibility;
    private static boolean isPaper;

    public static boolean isPaper() {
        return isPaper;
    }

    public static ICompatibility getCompatibility() {
        return compatibility;
    }

    public static EntityCompatibility getEntityCompatibility() {
        return compatibility.getEntityCompatibility();
    }

    public static BlockCompatibility getBlockCompatibility() {
        return compatibility.getBlockCompatibility();
    }

    public static NBTCompatibility getNBTCompatibility() {
        return compatibility.getNBTCompatibility();
    }

    public static CommandCompatibility getCommandCompatibility() {
        return compatibility.getCommandCompatibility();
    }

    public static WorldGuardCompatibility getWorldGuardCompatibility() {
        return worldGuardCompatibility;
    }

    public static IVaultCompatibility getVaultCompatibility() {
        if (vaultCompatibility == null) {
            boolean hasVault = Bukkit.getPluginManager().getPlugin("Vault") != null;
            String path = "me.deecaad.core.compatibility.vault." + (hasVault ? "VaultCompatibility" : "NoVaultCompatibility");
            vaultCompatibility = (IVaultCompatibility)ReflectionUtil.newInstance(ReflectionUtil.getClass(path));
        }
        return vaultCompatibility;
    }

    static {
        try {
            WorldGuardCompatibility worldGuardCompatibility1;
            boolean isPaper1;
            try {
                Class.forName("com.destroystokyo.paper.VersionHistoryManager$VersionData");
                isPaper1 = true;
            }
            catch (ClassNotFoundException ex) {
                isPaper1 = false;
            }
            isPaper = isPaper1;
            compatibility = new CompatibilitySetup().getCompatibleVersion(ICompatibility.class, "me.deecaad.core.compatibility");
            if (compatibility == null) {
                MechanicsCore.debug.error("Unsupported server version: " + Bukkit.getVersion() + " (" + Bukkit.getBukkitVersion() + ")", "Remember that MechanicsCore supports all major versions 1.12.2+, HOWEVER it doesn't support outdated versions", "For example, 1.18.1 is NOT a support version, but 1.18.2 IS a supported version", "If you are running a brand new version of Minecraft, ask DeeCaaD or CJCrafter to update the plugin", "", "!!! CRITICAL ERROR !!!");
            }
            try {
                Class.forName("com.sk89q.worldguard.bukkit.WorldGuardPlugin");
                if (!MinecraftVersions.UPDATE_AQUATIC.isAtLeast()) {
                    Constructor<?> worldGuardV6Constructor = ReflectionUtil.getConstructor(Class.forName("me.deecaad.core.compatibility.worldguard.WorldGuardV6"), new Class[0]);
                    worldGuardCompatibility1 = (WorldGuardCompatibility)ReflectionUtil.newInstance(worldGuardV6Constructor, new Object[0]);
                } else {
                    Constructor<?> worldGuardV7Constructor = ReflectionUtil.getConstructor(Class.forName("me.deecaad.core.compatibility.worldguard.WorldGuardV7"), new Class[0]);
                    worldGuardCompatibility1 = (WorldGuardCompatibility)ReflectionUtil.newInstance(worldGuardV7Constructor, new Object[0]);
                }
            }
            catch (Throwable e) {
                worldGuardCompatibility1 = new NoWorldGuard();
            }
            worldGuardCompatibility = worldGuardCompatibility1;
        }
        catch (Throwable ex) {
            MechanicsCore.debug.log(LogLevel.ERROR, "Failed to init CompatibilityAPI", ex);
        }
    }
}

