/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.commands.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import me.deecaad.core.commands.arguments.CommandArgumentType;
import me.deecaad.core.commands.arguments.LiteralArgumentType;

public class StringArgumentType
extends CommandArgumentType<String> {
    private boolean quotes;
    private List<LiteralArgumentType> literals;

    public StringArgumentType() {
    }

    public StringArgumentType(boolean quotes) {
        this.quotes = quotes;
    }

    public List<LiteralArgumentType> getLiterals() {
        return this.literals;
    }

    public StringArgumentType withLiteral(String literal) {
        if (this.literals == null) {
            this.literals = new ArrayList<LiteralArgumentType>();
        }
        this.literals.add(new LiteralArgumentType(literal));
        return this;
    }

    public StringArgumentType withLiterals(String ... literals) {
        for (String literal : literals) {
            this.withLiteral(literal);
        }
        return this;
    }

    public void clear() {
        this.literals.clear();
    }

    @Override
    public ArgumentType<String> getBrigadierType() {
        if (this.quotes) {
            return com.mojang.brigadier.arguments.StringArgumentType.string();
        }
        return com.mojang.brigadier.arguments.StringArgumentType.word();
    }

    @Override
    public String parse(CommandContext<Object> context, String key) {
        return (String)context.getArgument(key, String.class);
    }
}

