/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.commands.arguments;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.commands.CommandData;
import me.deecaad.core.commands.arguments.CommandArgumentType;
import me.deecaad.core.utils.StringUtil;

public class MapArgumentType
extends CommandArgumentType<Map<String, Object>> {
    private final Map<String, MapValueType<?>> types = new HashMap();

    public MapArgumentType with(String key, MapValueType<?> data) {
        this.types.put(key, data);
        return this;
    }

    @Override
    public ArgumentType<?> getBrigadierType() {
        return this.compatibility().nbtCompound();
    }

    @Override
    public Map<String, Object> parse(CommandContext<Object> context, String cmd) throws CommandSyntaxException {
        Map<String, Object> nbt = this.compatibility().getCompound(context, cmd);
        for (String key : nbt.keySet()) {
            Object value = nbt.get(key);
            if (!this.types.containsKey(key)) {
                throw new SimpleCommandExceptionType((Message)new LiteralMessage("Unknown argument '" + key + "', did you mean '" + StringUtil.didYouMean(key, this.types.keySet()) + "'")).create();
            }
            if (this.types.get((Object)key).type.isInstance(value)) continue;
            throw new SimpleCommandExceptionType((Message)new LiteralMessage("Expected " + this.types.get((Object)key).type.getSimpleName() + " got '" + String.valueOf(value) + "'")).create();
        }
        return nbt;
    }

    @Override
    public CompletableFuture<Suggestions> suggestions(CommandContext<Object> context, SuggestionsBuilder builder) {
        MapValueType<?> type;
        String current = builder.getRemaining();
        CommandData data = new CommandData(this.compatibility().getCommandSender(context), new Object[0], builder.getInput(), builder.getRemaining());
        if (current.isEmpty()) {
            builder.suggest("{", (Message)new LiteralMessage("Open tag"));
            return builder.buildFuture();
        }
        int i = MapArgumentType.traceBack(current, current.length() - 1);
        int j = MapArgumentType.traceBack(current, i - 1);
        char delimiter = current.charAt(i);
        String allBefore = current.substring(0, i);
        String before = current.substring(i == 0 ? 0 : j + 1, i);
        String after = current.substring(i + 1);
        Pattern pattern = Pattern.compile("\\w+:\\w+");
        Matcher matcher = pattern.matcher(allBefore);
        ArrayList<String> usesKeys = new ArrayList<String>();
        while (matcher.find()) {
            usesKeys.add(matcher.group().split(":")[0]);
        }
        List<Object> suggestions = delimiter == '{' || delimiter == ',' ? (this.types.containsKey(after) ? Collections.singletonList(after + ":") : this.types.keySet().stream().filter(s -> s.startsWith(after)).filter(s -> !usesKeys.contains(s)).collect(Collectors.toList())) : (delimiter == ':' ? ((type = this.types.get(before)) == null ? Collections.singletonList("Invalid Input") : (type.suggestions.contains(after) ? Arrays.asList(after + ",", after + "}") : type.suggestions.stream().filter(s -> s.startsWith(after)).collect(Collectors.toList()))) : Collections.singletonList("SHOULD NOT HAPPEN"));
        suggestions.stream().map(suggestion -> allBefore + delimiter + suggestion).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int traceBack(String str, int start) {
        if (start < 0) {
            return 0;
        }
        for (int i = start; i >= 0; --i) {
            if ("{,:".indexOf(str.charAt(i)) == -1) continue;
            return i;
        }
        MechanicsCore.debug.debug("Could not find any of '{,:' in '" + str + "' from '" + start + "'");
        return -1;
    }

    public static MapValueType<Integer> INT(Integer ... suggestions) {
        return new MapValueType<Integer>(Integer.class, suggestions);
    }

    public static MapValueType<Double> DOUBLE(Double ... suggestions) {
        return new MapValueType<Double>(Double.class, suggestions);
    }

    public static MapValueType<String> STRING(String ... suggestions) {
        return new MapValueType<String>(String.class, suggestions);
    }

    public static MapValueType<List> LIST(String ... suggestions) {
        return new MapValueType<List>(List.class, suggestions);
    }

    public static class MapValueType<T> {
        private final Class<?> type;
        private final List<String> suggestions;

        private MapValueType(Class<?> type, Object[] suggestions) {
            this.type = type;
            this.suggestions = Arrays.stream(suggestions).map(Object::toString).collect(Collectors.toList());
        }
    }
}

