/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.commands.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import me.deecaad.core.commands.arguments.CommandArgumentType;
import me.deecaad.core.utils.EnumUtil;
import me.deecaad.core.utils.SerializerUtil;

public abstract class ListArgumentType<T>
extends CommandArgumentType<List<T>> {
    private final List<T> examples;
    private final boolean strict;

    public ListArgumentType(List<T> examples, boolean strict) {
        this.examples = examples;
        this.strict = strict;
    }

    @Override
    public ArgumentType<?> getBrigadierType() {
        return StringArgumentType.string();
    }

    @Override
    public List<T> parse(CommandContext<Object> context, String key) throws CommandSyntaxException {
        String value = context.getInput();
        ArrayList<T> temp = new ArrayList<T>();
        for (String str : value.split(",")) {
            try {
                temp.add(this.parse(str));
            }
            catch (CommandSyntaxException e) {
                throw e;
            }
            catch (Exception e) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().create((Object)str);
            }
        }
        return temp;
    }

    @Override
    public CompletableFuture<Suggestions> suggestions(CommandContext<Object> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        boolean complete;
        String value = context.getInput();
        int newElementLocation = value.lastIndexOf(44) + 1;
        String previous = value.substring(0, newElementLocation);
        String current = value.substring(newElementLocation);
        if (this.strict) {
            complete = this.examples.stream().map(Objects::toString).anyMatch(current::equalsIgnoreCase);
        } else {
            try {
                this.parse(current);
                complete = true;
            }
            catch (Throwable ignore) {
                complete = false;
            }
        }
        if (complete) {
            builder.suggest(previous + ",");
        } else {
            for (T example : this.examples) {
                builder.suggest(previous + example.toString());
            }
        }
        return builder.buildFuture();
    }

    public abstract T parse(String var1) throws CommandSyntaxException;

    public static ListArgumentType<Integer> integers(Integer ... examples) {
        return new ListArgumentType<Integer>(Arrays.asList(examples), false){

            @Override
            public Integer parse(String str) throws CommandSyntaxException {
                try {
                    return Integer.parseInt(str);
                }
                catch (NumberFormatException e) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().create((Object)str);
                }
            }
        };
    }

    public static ListArgumentType<Double> doubles(Double ... examples) {
        return new ListArgumentType<Double>(Arrays.asList(examples), false){

            @Override
            public Double parse(String str) throws CommandSyntaxException {
                try {
                    return Double.parseDouble(str);
                }
                catch (NumberFormatException e) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidDouble().create((Object)str);
                }
            }
        };
    }

    public static <T extends Enum<T>> ListArgumentType<T> enums(final Class<T> clazz) {
        return new ListArgumentType<T>(EnumUtil.getValues(clazz), true){

            @Override
            public T parse(String str) throws CommandSyntaxException {
                try {
                    return (Enum)EnumUtil.getIfPresent(clazz, str).orElseThrow(() -> new IllegalArgumentException(str));
                }
                catch (IllegalArgumentException ex) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().create((Object)("Unknown: " + str + ", Did you mean: " + SerializerUtil.didYouMeanEnum(str, clazz)));
                }
            }
        };
    }
}

