/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import me.deecaad.core.commands.CommandData;
import me.deecaad.core.commands.Tooltip;

public class SuggestionsBuilder {
    private final List<Tooltip> options = new ArrayList<Tooltip>();
    private Function<CommandData, Tooltip[]> function;

    public SuggestionsBuilder with(Object option) {
        if (option == null) {
            throw new IllegalArgumentException("option cannot be null");
        }
        if (option instanceof Tooltip) {
            this.options.add((Tooltip)option);
        } else if (option instanceof Collection) {
            this.with((Collection)option);
        } else if (option.getClass().isArray()) {
            this.with((Object[])option);
        } else {
            this.options.add(Tooltip.of(option));
        }
        return this;
    }

    public SuggestionsBuilder with(Object ... options) {
        for (Object obj : options) {
            this.with(obj);
        }
        return this;
    }

    public SuggestionsBuilder with(Collection<Object> options) {
        for (Object obj : options) {
            this.with(obj);
        }
        return this;
    }

    public SuggestionsBuilder with(Function<CommandData, Tooltip[]> function) {
        this.function = function;
        return this;
    }

    public Function<CommandData, Tooltip[]> build() {
        return data -> {
            ArrayList<Tooltip> suggestions = new ArrayList<Tooltip>(this.options.size() + (this.function == null ? 0 : 10));
            suggestions.addAll(this.options);
            if (this.function != null) {
                Collections.addAll(suggestions, this.function.apply((CommandData)data));
            }
            return suggestions.toArray(new Tooltip[0]);
        };
    }

    public static Function<CommandData, Tooltip[]> from(Object ... options) {
        return new SuggestionsBuilder().with(options).build();
    }

    public static Function<CommandData, Tooltip[]> range(int min, int max) {
        return data -> (Tooltip[])IntStream.rangeClosed(min, max).mapToObj(Tooltip::of).toArray(Tooltip[]::new);
    }
}

