/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.commands.CommandPermission;
import me.deecaad.core.commands.SubCommands;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.core.utils.StringUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;

@Deprecated
public abstract class SubCommand
extends BukkitCommand {
    protected static final String PLAYERS = "<player>";
    protected static final String INTEGERS = "<amount>";
    protected static final String SUB_COMMANDS = "<subcommand>";
    private static final SimpleCommandMap COMMAND_MAP;
    protected final SubCommands commands;
    private final String prefix;
    private final String[] args;

    public SubCommand(String parentPrefix, String label, String desc) {
        this(parentPrefix, label, desc, "");
    }

    public SubCommand(String parentPrefix, String label, String desc, String usage) {
        label = label.toLowerCase(Locale.ROOT);
        super(label);
        this.prefix = parentPrefix.toLowerCase(Locale.ROOT) + " " + label;
        this.commands = new SubCommands(this.prefix);
        this.args = StringUtil.splitAfterWord(usage).toArray(new String[0]);
        this.setDescription(desc);
        if (((Object)((Object)this)).getClass().isAnnotationPresent(CommandPermission.class)) {
            CommandPermission perm = ((Object)((Object)this)).getClass().getAnnotation(CommandPermission.class);
            String str = perm.permission();
            Permission permission = new Permission(str);
            permission.addParent(str.substring(0, str.lastIndexOf(".")) + ".*", true);
            Bukkit.getPluginManager().addPermission(permission);
        }
    }

    public String[] getArgs() {
        return (String[])this.args.clone();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPermission() {
        if (((Object)((Object)this)).getClass().isAnnotationPresent(CommandPermission.class)) {
            return ((Object)((Object)this)).getClass().getAnnotation(CommandPermission.class).permission();
        }
        return super.getPermission();
    }

    protected boolean sendHelp(CommandSender sender, String[] args) {
        if (this.commands.isEmpty()) {
            TextComponent.Builder builder = Component.text();
            HoverEvent hover = HoverEvent.showText((Component)Component.text((String)"Click to fill command").color((TextColor)NamedTextColor.GRAY));
            ClickEvent click = ClickEvent.suggestCommand((String)("/" + this.prefix));
            builder.append(((TextComponent)((TextComponent)Component.text((String)("/" + this.prefix + " " + String.join((CharSequence)" ", args))).color((TextColor)NamedTextColor.GOLD)).clickEvent(click)).hoverEvent((HoverEventSource)hover));
            builder.append(((TextComponent)((TextComponent)Component.text((String)(": " + this.description)).color((TextColor)NamedTextColor.GRAY)).clickEvent(click)).hoverEvent((HoverEventSource)hover));
            MechanicsCore.getPlugin().adventure.sender(sender).sendMessage((ComponentLike)builder);
            return true;
        }
        return this.commands.sendHelp(sender, args);
    }

    List<String> tabCompletions(String[] args) {
        String current;
        if (args.length == 0) {
            return new ArrayList<String>();
        }
        switch (current = this.args.length >= args.length ? this.args[args.length - 1] : "OUT_OF_BOUNDS") {
            case "<player>": {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            }
            case "<amount>": {
                return List.of("1", "16", "64", "128");
            }
            case "<subcommand>": {
                return this.commands.keys();
            }
            case "OUT_OF_BOUNDS": {
                int index = ArrayUtils.indexOf((Object[])this.args, (Object)SUB_COMMANDS);
                if (index == -1) {
                    return new ArrayList<String>();
                }
                return this.commands.tabCompletions(args[index], Arrays.copyOfRange(args, index + 1, args.length));
            }
        }
        if (current.contains(",")) {
            String[] split = current.replaceAll("[<>]", "").split(",");
            return Arrays.asList(split);
        }
        return this.handleCustomTag(args, current);
    }

    protected List<String> handleCustomTag(String[] args, String current) {
        return List.of(current);
    }

    public abstract void execute(CommandSender var1, String[] var2);

    public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (this.getPermission() != null && !sender.hasPermission(this.getPermission())) {
            sender.sendMessage((String)(this.getPermissionMessage() == null ? String.valueOf(ChatColor.RED) + "Invalid Permissions" : this.getPermissionMessage()));
            return false;
        }
        if (args.length > 1) {
            if (args[0].equals("help")) {
                this.sendHelp(sender, Arrays.copyOfRange(args, 1, args.length));
            } else {
                this.execute(sender, args);
            }
        } else {
            this.execute(sender, args);
        }
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
        if (this.getPermission() != null && !sender.hasPermission(this.getPermission())) {
            return Collections.emptyList();
        }
        return this.tabCompletions(args);
    }

    public String toString() {
        return String.valueOf(ChatColor.GOLD) + "/" + this.prefix + " " + String.join((CharSequence)" ", this.args) + String.valueOf(ChatColor.GRAY) + ": " + this.description;
    }

    public void register() {
        COMMAND_MAP.register(this.getLabel(), (Command)this);
    }

    static {
        Method getCommandMap = ReflectionUtil.getMethod(ReflectionUtil.getCBClass("CraftServer"), "getCommandMap", new Class[0]);
        COMMAND_MAP = (SimpleCommandMap)ReflectionUtil.invokeMethod(getCommandMap, Bukkit.getServer(), new Object[0]);
    }
}

