/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.commands;

import java.util.List;
import java.util.Locale;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.commands.Argument;
import me.deecaad.core.commands.CommandBuilder;
import me.deecaad.core.commands.CommandExecutor;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.ChatColor;

public class HelpCommandBuilder {
    private HelpCommandBuilder() {
    }

    public static void register(CommandBuilder command, HelpColor color) {
        CommandBuilder help = new CommandBuilder("help").withAliases("?").withDescription(command.label);
        HelpCommandBuilder.buildHelp(help, command, color);
        help.withDescription("Displays useful information about how to use the commands");
        command.withSubcommand(help);
    }

    private static void buildHelp(CommandBuilder help, CommandBuilder parent, HelpColor color) {
        for (CommandBuilder subcommand : parent.subcommands) {
            CommandBuilder subHelp = new CommandBuilder(subcommand.label).withPermission(subcommand.permission).withRequirements(subcommand.requirements).withDescription(help.description + " " + subcommand.label);
            help.withSubcommand(subHelp);
            HelpCommandBuilder.buildHelp(subHelp, subcommand, color);
        }
        if (help.subcommands.isEmpty()) {
            help.cache = (TextComponent)HelpCommandBuilder.buildCommandWithoutSubcommands(help, parent, color).build();
            help.executes(CommandExecutor.any((sender, args) -> MechanicsCore.getPlugin().adventure.sender(sender).sendMessage((Component)help.cache)));
            if (!parent.args.isEmpty() && parent.args.get(0).isRequired()) {
                CommandBuilder friend = new CommandBuilder(parent.label).withDescription(parent.description).withPermission(parent.permission).withRequirements(parent.requirements);
                friend.executes(CommandExecutor.any((sender, args) -> MechanicsCore.getPlugin().adventure.sender(sender).sendMessage((Component)help.cache)));
                parent.friend = friend;
            }
        } else {
            help.cache = (TextComponent)HelpCommandBuilder.buildCommandWithSubcommands(help, parent, color).build();
            help.executes(CommandExecutor.any((sender, args) -> MechanicsCore.getPlugin().adventure.sender(sender).sendMessage((Component)help.cache)));
            if (parent.executor == null) {
                parent.executes(CommandExecutor.any((sender, args) -> MechanicsCore.getPlugin().adventure.sender(sender).sendMessage((Component)help.cache)));
            }
        }
    }

    private static TextComponent.Builder universal(CommandBuilder help, CommandBuilder parent, HelpColor color) {
        TextComponent.Builder builder = Component.text();
        builder.append(Component.text().content("/" + help.description + ": ").style(color.a));
        builder.append(Component.text().content(String.valueOf(parent.description)).style(color.b));
        builder.append((Component)Component.newline());
        if (parent.permission != null) {
            builder.append(((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Permission: ").style(color.a)).clickEvent(ClickEvent.copyToClipboard((String)parent.permission.getName()))).hoverEvent((HoverEventSource)Component.text((String)"Click to copy")));
            builder.append(((TextComponent.Builder)((TextComponent.Builder)Component.text().content(parent.permission.getName()).style(color.b)).clickEvent(ClickEvent.copyToClipboard((String)parent.permission.getName()))).hoverEvent((HoverEventSource)Component.text((String)"Click to copy")));
            builder.append((Component)Component.newline());
        }
        if (!parent.aliases.isEmpty()) {
            builder.append(Component.text().content("Aliases: ").style(color.a));
            builder.append(Component.text().content(String.join((CharSequence)", ", parent.aliases)).style(color.b));
            builder.append((Component)Component.newline());
        }
        return builder;
    }

    private static TextComponent.Builder buildCommandWithSubcommands(CommandBuilder help, CommandBuilder parent, HelpColor color) {
        TextComponent.Builder builder = HelpCommandBuilder.universal(help, parent, color);
        builder.append((Component)Component.newline());
        List<CommandBuilder> subcommands = parent.subcommands;
        for (int i = 0; i < subcommands.size(); ++i) {
            CommandBuilder subcommand = subcommands.get(i);
            builder.append(((TextComponent.Builder)((TextComponent.Builder)Component.text().content("<" + subcommand.label + ">: ").style(color.a)).clickEvent(ClickEvent.suggestCommand((String)("/" + help.description + " " + subcommand.label)))).hoverEvent((HoverEventSource)subcommand.cache));
            builder.append(((TextComponent.Builder)((TextComponent.Builder)Component.text().content(String.valueOf(subcommand.description)).style(color.b)).clickEvent(ClickEvent.suggestCommand((String)("/" + help.description + " " + subcommand.label)))).hoverEvent((HoverEventSource)subcommand.cache));
            if (i == subcommands.size() - 1) continue;
            builder.append((Component)Component.newline());
        }
        return builder;
    }

    private static TextComponent.Builder buildCommandWithoutSubcommands(CommandBuilder help, CommandBuilder parent, HelpColor color) {
        TextComponent.Builder builder = HelpCommandBuilder.universal(help, parent, color);
        builder.append(Component.text().content("Usage: ").style(color.a));
        builder.append(((TextComponent.Builder)((TextComponent.Builder)Component.text().content("/" + help.description).style(color.b)).clickEvent(ClickEvent.suggestCommand((String)("/" + help.description)))).hoverEvent((HoverEventSource)Component.text((String)"Click to run")));
        for (Argument<Object> arg : parent.args) {
            arg.append(builder, color.b);
        }
        if (!parent.args.isEmpty()) {
            builder.append((Component)Component.newline());
            builder.append((Component)Component.newline());
            List<Argument<Object>> args = parent.args;
            for (int i = 0; i < args.size(); ++i) {
                Argument<Object> arg = args.get(i);
                arg.append(builder, color.a);
                builder.append(Component.text().content(": ").style(color.a));
                builder.append(Component.text().content(String.valueOf(arg.description)).style(color.b));
                if (i == args.size() - 1) continue;
                builder.append((Component)Component.newline());
            }
        }
        return builder;
    }

    public static final class HelpColor {
        public Style a;
        public Style b;
        public String symbol;

        public HelpColor(Style a, Style b, String symbol) {
            this.a = a;
            this.b = b;
            this.symbol = symbol;
        }

        public static HelpColor from(ChatColor a, ChatColor b, char c) {
            return new HelpColor(Style.style((TextColor)((TextColor)NamedTextColor.NAMES.value((Object)a.name().toLowerCase(Locale.ROOT))), (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}), Style.style((TextColor)((TextColor)NamedTextColor.NAMES.value((Object)b.name().toLowerCase(Locale.ROOT)))), String.valueOf(c));
        }
    }
}

