/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.commands;

import java.util.function.BiConsumer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class CommandExecutor<T extends CommandSender> {
    private final Class<T> executor;

    public CommandExecutor(Class<T> executor) {
        this.executor = executor;
    }

    public final Class<T> getExecutor() {
        return this.executor;
    }

    public abstract void execute(T var1, Object[] var2);

    public static CommandExecutor<CommandSender> any(final BiConsumer<CommandSender, Object[]> command) {
        return new CommandExecutor<CommandSender>(CommandSender.class){

            @Override
            public void execute(CommandSender sender, Object[] arguments) {
                command.accept(sender, arguments);
            }
        };
    }

    public static CommandExecutor<Entity> entity(final BiConsumer<Entity, Object[]> command) {
        return new CommandExecutor<Entity>(Entity.class){

            @Override
            public void execute(Entity sender, Object[] arguments) {
                command.accept(sender, arguments);
            }
        };
    }

    public static CommandExecutor<Player> player(final BiConsumer<Player, Object[]> command) {
        return new CommandExecutor<Player>(Player.class){

            @Override
            public void execute(Player sender, Object[] arguments) {
                command.accept(sender, arguments);
            }
        };
    }
}

