/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.deecaad.core.commands.Argument;
import me.deecaad.core.commands.BrigadierCommand;
import me.deecaad.core.commands.CommandException;
import me.deecaad.core.commands.CommandExecutor;
import me.deecaad.core.commands.HelpCommandBuilder;
import me.deecaad.core.commands.arguments.GreedyArgumentType;
import me.deecaad.core.commands.arguments.LiteralArgumentType;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.utils.MinecraftVersions;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class CommandBuilder
implements Cloneable {
    String label;
    Permission permission;
    Predicate<CommandSender> requirements;
    List<String> aliases;
    List<Argument<Object>> args;
    List<CommandBuilder> subcommands;
    CommandExecutor<? extends CommandSender> executor;
    String description;
    Object[] optionalDefaultValues;
    TextComponent cache;
    CommandBuilder friend;

    public CommandBuilder(String label) {
        if (label == null || label.trim().isEmpty()) {
            throw new IllegalArgumentException("null or empty string: " + label);
        }
        this.label = label;
        this.permission = null;
        this.aliases = new ArrayList<String>();
        this.args = new ArrayList<Argument<Object>>();
        this.subcommands = new ArrayList<CommandBuilder>();
        this.executor = null;
        this.optionalDefaultValues = new Object[0];
    }

    public CommandBuilder withPermission(String permission) {
        Permission temp = new Permission(permission);
        return this.withPermission(temp);
    }

    public CommandBuilder withPermission(String permission, PermissionDefault def) {
        Permission temp = new Permission(permission, def);
        return this.withPermission(temp);
    }

    public CommandBuilder withPermission(Permission permission) {
        this.permission = permission;
        if (permission != null && Bukkit.getPluginManager().getPermission(permission.getName()) == null) {
            Bukkit.getPluginManager().addPermission(permission);
        }
        return this;
    }

    public CommandBuilder withRequirements(Predicate<CommandSender> requirements) {
        this.requirements = requirements;
        return this;
    }

    public CommandBuilder withAliases(String ... aliases) {
        this.aliases.addAll(Arrays.asList(aliases));
        return this;
    }

    public CommandBuilder withArgument(Argument<?> argument) {
        Argument<Object> previous;
        Argument<Object> argument2 = previous = this.args.size() == 0 ? null : this.args.get(this.args.size() - 1);
        if (argument.isRequired() && previous != null && !previous.isRequired()) {
            throw new CommandException("Cannot have a required argument after optional argument. For: " + String.valueOf(this) + " + " + String.valueOf(argument));
        }
        if (argument.getType() instanceof GreedyArgumentType) {
            if (this.args.stream().map(Argument::getType).anyMatch(GreedyArgumentType.class::isInstance)) {
                throw new CommandException("Cannot have multiple greedy arguments. For: " + String.valueOf(this) + " + " + String.valueOf(argument));
            }
        }
        this.args.add(argument);
        return this;
    }

    public CommandBuilder withArguments(Argument<?> ... arguments) {
        for (Argument<?> argument : arguments) {
            this.withArgument(argument);
        }
        return this;
    }

    public CommandBuilder withArguments(List<Argument<?>> arguments) {
        for (Argument<?> argument : arguments) {
            this.withArgument(argument);
        }
        return this;
    }

    public CommandBuilder withSubcommand(CommandBuilder builder) {
        this.subcommands.add(builder);
        return this;
    }

    public CommandBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public <T extends CommandSender> CommandBuilder executes(CommandExecutor<T> executor) {
        this.executor = executor;
        return this;
    }

    public CommandBuilder register() {
        this.validate();
        if (!MinecraftVersions.UPDATE_AQUATIC.isAtLeast()) {
            throw new IllegalStateException("oops forgot to add legacy");
        }
        BrigadierCommand.register(this);
        return this;
    }

    public CommandBuilder registerHelp(HelpCommandBuilder.HelpColor color) {
        HelpCommandBuilder.register(this, color);
        return this;
    }

    private void validate() {
        if (!this.args.isEmpty() && !this.subcommands.isEmpty()) {
            throw new CommandException("Cannot use arguments and sub-commands at the same time!");
        }
        if (this.subcommands.isEmpty() && this.executor == null) {
            throw new CommandException("You forgot to add an executor or sub-commands to your command!");
        }
        this.subcommands.forEach(CommandBuilder::validate);
    }

    public Predicate<Object> requirements() {
        return nms -> {
            CommandSender sender = CompatibilityAPI.getCommandCompatibility().getCommandSenderRaw(nms);
            if (this.permission != null && !sender.hasPermission(this.permission)) {
                return false;
            }
            return this.requirements == null || this.requirements.test(sender);
        };
    }

    public CommandBuilder clone() {
        try {
            CommandBuilder builder = (CommandBuilder)super.clone();
            builder.subcommands = new ArrayList<CommandBuilder>(builder.subcommands);
            builder.args = new ArrayList<Argument<Object>>(builder.args);
            builder.cache = null;
            return builder;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return "/" + this.label + " " + this.args.stream().map(arg -> LiteralArgumentType.class.isInstance(arg.getType()) ? arg.getName() : "<" + arg.getName() + ">").collect(Collectors.joining(" ")) + " " + Arrays.stream(this.optionalDefaultValues).map(Objects::toString).collect(Collectors.joining(" "));
    }
}

