/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.commands.Argument;
import me.deecaad.core.commands.CommandBuilder;
import me.deecaad.core.commands.CommandExecutor;
import me.deecaad.core.commands.HelpCommandBuilder;
import me.deecaad.core.commands.SuggestionsBuilder;
import me.deecaad.core.commands.arguments.StringArgumentType;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.utils.StringUtil;
import me.deecaad.core.utils.TableBuilder;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

public final class MechanicsCoreCommand {
    public static char SYM = (char)10146;

    private MechanicsCoreCommand() {
    }

    public static void build() {
        CommandBuilder command = new CommandBuilder("mechanicscore").withPermission("mechanicscore.admin").withDescription("MechanicsCore debug/test commands").withSubcommand(new CommandBuilder("table").withPermission("mechanicscore.commands.table").withDescription("Helpful tables that are used on the wiki").withSubcommand(new CommandBuilder("colors").withPermission("mechanicscore.commands.table.colors").withDescription("Shows legacy color codes and the adventure version").executes(CommandExecutor.any((sender, args) -> MechanicsCoreCommand.tableColors(sender))))).withSubcommand(new CommandBuilder("reloadcommands").withPermission("mechanicscore.commands.reloadcommands").withDescription("Resends command registry to all online players").executes(CommandExecutor.any((sender, args) -> MechanicsCoreCommand.reloadCommands(sender)))).withSubcommand(new CommandBuilder("printcommands").withPermission("mechanicscore.commands.printcommands").withDescription("Prints the server's entire command registry to json file").withArgument(new Argument<String>("file", new StringArgumentType(), "commands").append(SuggestionsBuilder.from("file", "commands"))).executes(CommandExecutor.any((sender, args) -> MechanicsCoreCommand.printCommands(sender, (String)args[0])))).withSubcommand(new CommandBuilder("plugins").withPermission("mechanicscore.commands.plugins").withDescription("Shows all plugins currently using MechanicsCore").executes(CommandExecutor.any((sender, args) -> MechanicsCoreCommand.listPlugins(sender))));
        HelpCommandBuilder.register(command, HelpCommandBuilder.HelpColor.from(ChatColor.GOLD, ChatColor.GRAY, SYM));
        command.register();
    }

    public static void reloadCommands(CommandSender sender) {
        Bukkit.getOnlinePlayers().forEach(CompatibilityAPI.getCommandCompatibility()::resendCommandRegistry);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Resent commands");
    }

    public static void printCommands(CommandSender sender, String name) {
        if (!((String)name).endsWith(".json")) {
            name = (String)name + ".json";
        }
        File output = new File(MechanicsCore.getPlugin().getDataFolder(), (String)name);
        CompatibilityAPI.getCommandCompatibility().generateFile(output);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Wrote command registry to " + String.valueOf(output));
    }

    public static void listPlugins(CommandSender sender) {
        List<Plugin> plugins = Arrays.stream(Bukkit.getPluginManager().getPlugins()).filter(plugin -> {
            PluginDescriptionFile desc = plugin.getDescription();
            return desc.getDepend().contains("MechanicsCore") || desc.getSoftDepend().contains("MechanicsCore");
        }).toList();
        Style gold = Style.style((TextColor)NamedTextColor.GOLD);
        Style gray = Style.style((TextColor)NamedTextColor.GRAY);
        TextComponent table = new TableBuilder().withConstraints(TableBuilder.DEFAULT_CONSTRAINTS).withElementChar('-').withElementCharStyle(gold).withFillChar('=').withFillCharStyle(Style.style((TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.STRIKETHROUGH})).withHeader("Plugins using MechanicsCore").withHeaderStyle(gold).withElementStyle(gray).withAttemptSinglePixelFix().withSupplier(i -> {
            if (plugins.size() <= i) {
                return Component.empty();
            }
            Plugin plugin = (Plugin)plugins.get(i);
            PluginDescriptionFile desc = plugin.getDescription();
            TextComponent.Builder hover = Component.text();
            ((TextComponent.Builder)((TextComponent.Builder)hover.append((Component)Component.text((String)"Version: ", (Style)gray))).append((Component)Component.text((String)desc.getVersion(), (Style)gold))).append((Component)Component.newline());
            ((TextComponent.Builder)hover.append((Component)Component.text((String)"Authors: ", (Style)gray))).append((Component)Component.text((String)desc.getAuthors().toString(), (Style)gold));
            return (TextComponent)((TextComponent.Builder)Component.text().content(plugin.getName().toUpperCase(Locale.ROOT)).hoverEvent((HoverEventSource)hover.build())).build();
        }).build();
        MechanicsCore.getPlugin().adventure.sender(sender).sendMessage((Component)table);
    }

    public static void tableColors(CommandSender sender) {
        ArrayList<ColorData> colors = new ArrayList<ColorData>();
        colors.add(new ColorData("&0", "<black>", (TextColor)NamedTextColor.BLACK));
        colors.add(new ColorData("&1", "<dark_blue>", (TextColor)NamedTextColor.DARK_BLUE));
        colors.add(new ColorData("&2", "<dark_green>", (TextColor)NamedTextColor.DARK_GREEN));
        colors.add(new ColorData("&3", "<dark_aqua>", (TextColor)NamedTextColor.DARK_AQUA));
        colors.add(new ColorData("&4", "<dark_red>", (TextColor)NamedTextColor.DARK_RED));
        colors.add(new ColorData("&5", "<dark_purple>", (TextColor)NamedTextColor.DARK_PURPLE));
        colors.add(new ColorData("&6", "<gold>", (TextColor)NamedTextColor.GOLD));
        colors.add(new ColorData("&7", "<gray>", (TextColor)NamedTextColor.GRAY));
        colors.add(new ColorData("&8", "<dark_gray>", (TextColor)NamedTextColor.DARK_GRAY));
        colors.add(new ColorData("&9", "<blue>", (TextColor)NamedTextColor.BLUE));
        colors.add(new ColorData("&a", "<green>", (TextColor)NamedTextColor.GREEN));
        colors.add(new ColorData("&b", "<aqua>", (TextColor)NamedTextColor.AQUA));
        colors.add(new ColorData("&c", "<red>", (TextColor)NamedTextColor.RED));
        colors.add(new ColorData("&d", "<light_purple>", (TextColor)NamedTextColor.LIGHT_PURPLE));
        colors.add(new ColorData("&e", "<yellow>", (TextColor)NamedTextColor.YELLOW));
        colors.add(new ColorData("&f", "<white>", (TextColor)NamedTextColor.WHITE));
        ArrayList<ColorData> decorations = new ArrayList<ColorData>();
        decorations.add(new ColorData("&k", "<obfuscated>", TextDecoration.OBFUSCATED));
        decorations.add(new ColorData("&l", "<bold>", TextDecoration.BOLD));
        decorations.add(new ColorData("&m", "<strikethrough>", TextDecoration.STRIKETHROUGH));
        decorations.add(new ColorData("&n", "<underline>", TextDecoration.UNDERLINED));
        decorations.add(new ColorData("&o", "<italic>", TextDecoration.ITALIC));
        decorations.add(new ColorData("&r", "<reset>", (TextColor)NamedTextColor.WHITE));
        TextComponent colorComponent = new TableBuilder().withFillChar('=').withFillCharStyle(Style.style((TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.STRIKETHROUGH})).withHeader("COLORS").withHeaderStyle(Style.style((TextColor)NamedTextColor.GOLD)).withConstraints(TableBuilder.DEFAULT_CONSTRAINTS.setRows(8)).withSupplier(i -> ((ColorData)colors.get(i)).build()).build();
        TextComponent decorationComponent = new TableBuilder().withFillChar('=').withFillCharStyle(Style.style((TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.STRIKETHROUGH})).withHeader("DECORATIONS").withHeaderStyle(Style.style((TextColor)NamedTextColor.GOLD)).withConstraints(TableBuilder.DEFAULT_CONSTRAINTS.setRows(3)).withSupplier(i -> ((ColorData)decorations.get(i)).build()).build();
        TextComponent miscComponent = new TableBuilder().withFillChar('=').withFillCharStyle(Style.style((TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.STRIKETHROUGH})).withHeader("MISCELLANEOUS").withHeaderStyle(Style.style((TextColor)NamedTextColor.GOLD)).withConstraints(TableBuilder.DEFAULT_CONSTRAINTS.setRows(3).setColumns(1)).withSupplier(i -> switch (i) {
            case 0 -> new ColorData("&#7D5A2D", "<#7D5A2D>", TextColor.color((int)125, (int)90, (int)45)).alt("The five boxing wizards jump quickly").build();
            case 1 -> (TextComponent)Component.text((String)"<rainbow> = ").append(MechanicsCore.getPlugin().message.deserialize((Object)"<rainbow>The quick brown fox jumps over the lazy dog"));
            case 2 -> (TextComponent)Component.text((String)"<gradient:green:#ff0000> = ").append(MechanicsCore.getPlugin().message.deserialize((Object)"<gradient:green:#ff0000>A wizard's job is to vex chumps"));
            default -> throw new RuntimeException("unreachable code");
        }).build();
        Audience audience = MechanicsCore.getPlugin().adventure.sender(sender);
        audience.sendMessage(colorComponent.append((Component)decorationComponent).append((Component)miscComponent).append(new TableBuilder.Line('=', Style.style((TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.STRIKETHROUGH})).build()));
    }

    private static class ColorData {
        private String legacy;
        private String adventure;
        private TextColor color;
        private TextDecoration decoration;
        private String altText;

        public ColorData(String legacy, String adventure, TextColor color) {
            this.legacy = legacy;
            this.adventure = adventure;
            this.color = color;
        }

        public ColorData(String legacy, String adventure, TextDecoration decoration) {
            this.legacy = legacy;
            this.adventure = adventure;
            this.decoration = decoration;
        }

        private ColorData alt(String altText) {
            this.altText = altText;
            return this;
        }

        private TextComponent build() {
            String readable;
            TextComponent.Builder builder = Component.text();
            builder.append((Component)Component.text((String)(this.adventure + " = ")));
            String string = readable = this.altText != null ? this.altText : StringUtil.snakeToReadable(this.adventure.substring(1, this.adventure.length() - 1));
            if (this.color != null) {
                builder.append(Component.text((String)readable).color(this.color));
            } else {
                builder.append(Component.text((String)readable).decorate(this.decoration));
            }
            return (TextComponent)builder.build();
        }
    }
}

