/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.core;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.jar.JarFile;
import me.deecaad.core.MechanicsCoreCommand;
import me.deecaad.core.events.QueueSerializerEvent;
import me.deecaad.core.events.triggers.EquipListener;
import me.deecaad.core.file.JarSearcher;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerInstancer;
import me.deecaad.core.listeners.ItemCraftListener;
import me.deecaad.core.listeners.MechanicsCastListener;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.mechanics.conditions.Condition;
import me.deecaad.core.mechanics.conditions.GeyserCondition;
import me.deecaad.core.mechanics.conditions.MythicMobsEntityCondition;
import me.deecaad.core.mechanics.conditions.MythicMobsFactionCondition;
import me.deecaad.core.mechanics.defaultmechanics.Mechanic;
import me.deecaad.core.mechanics.defaultmechanics.MythicSkillMechanic;
import me.deecaad.core.mechanics.defaultmechanics.SculkBloomMechanic;
import me.deecaad.core.mechanics.defaultmechanics.SculkShriekMechanic;
import me.deecaad.core.mechanics.targeters.Targeter;
import me.deecaad.core.placeholder.PlaceholderHandler;
import me.deecaad.core.utils.Debugger;
import me.deecaad.core.utils.FileUtil;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.MinecraftVersions;
import me.deecaad.core.utils.ReflectionUtil;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MechanicsCore
extends JavaPlugin {
    private static MechanicsCore instance;
    public static Debugger debug;
    public BukkitAudiences adventure;
    public MiniMessage message;
    private boolean registeredMechanics;

    public void onLoad() {
        instance = this;
        int level = this.getConfig().getInt("Debug_Level");
        boolean printTraces = this.getConfig().getBoolean("Print_Traces");
        debug = new Debugger(this.getLogger(), level, printTraces);
        if (!this.registeredMechanics) {
            this.registeredMechanics = true;
            try {
                JarSearcher searcher = new JarSearcher(new JarFile(this.getFile()));
                searcher.findAllSubclasses(Mechanic.class, this.getClassLoader(), true, new Class[0]).stream().map(ReflectionUtil::newInstance).forEach(Mechanics.MECHANICS::add);
                searcher.findAllSubclasses(Targeter.class, this.getClassLoader(), true, new Class[0]).stream().map(ReflectionUtil::newInstance).forEach(Mechanics.TARGETERS::add);
                searcher.findAllSubclasses(Condition.class, this.getClassLoader(), true, new Class[0]).stream().map(ReflectionUtil::newInstance).forEach(Mechanics.CONDITIONS::add);
                if (MinecraftVersions.TRAILS_AND_TAILS.get(2).isAtLeast()) {
                    Mechanics.MECHANICS.add(new SculkShriekMechanic());
                    Mechanics.MECHANICS.add(new SculkBloomMechanic());
                }
                try {
                    if (this.getServer().getPluginManager().getPlugin("MythicMobs") != null) {
                        Mechanics.MECHANICS.add(new MythicSkillMechanic());
                        Mechanics.CONDITIONS.add(new MythicMobsEntityCondition());
                        Mechanics.CONDITIONS.add(new MythicMobsFactionCondition());
                    }
                }
                catch (Throwable ex) {
                    debug.warn("Cannot hook into MythicMobs... MythicMobs might be outdated");
                }
                try {
                    if (this.getServer().getPluginManager().isPluginEnabled("Geyser-Spigot")) {
                        Mechanics.CONDITIONS.add(new GeyserCondition());
                    }
                }
                catch (Throwable ex) {
                    debug.warn("Cannot hook into Geyser... Geyser might be outdated");
                }
                searcher.findAllSubclasses(PlaceholderHandler.class, this.getClassLoader(), true, new Class[0]).stream().map(ReflectionUtil::newInstance).forEach(PlaceholderHandler.REGISTRY::add);
            }
            catch (IOException ex) {
                debug.log(LogLevel.ERROR, "Error while searching Jar", ex);
            }
        }
    }

    public void onEnable() {
        debug.debug("Loading config.yml");
        if (!this.getDataFolder().exists() || this.getDataFolder().listFiles() == null || this.getDataFolder().listFiles().length == 0) {
            FileUtil.copyResourcesTo(this.getClassLoader().getResource("MechanicsCore"), this.getDataFolder().toPath());
        }
        FileUtil.ensureDefaults(this.getClassLoader().getResource("MechanicsCore/config.yml"), new File(this.getDataFolder(), "config.yml"));
        Bukkit.getPluginManager().registerEvents((Listener)EquipListener.SINGLETON, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ItemCraftListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new MechanicsCastListener(), (Plugin)this);
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.message = MiniMessage.miniMessage();
        File itemsFolder = new File(this.getDataFolder(), "Items");
        if (itemsFolder.exists()) {
            debug.error("Found Items folder... This feature is no longer supported. Please remove the Items folder.");
        }
        if (MinecraftVersions.UPDATE_AQUATIC.isAtLeast()) {
            MechanicsCoreCommand.build();
        }
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onQueue(QueueSerializerEvent event) throws IOException {
                List<Serializer<?>> serializers = new SerializerInstancer(new JarFile(MechanicsCore.this.getFile())).createAllInstances(MechanicsCore.this.getClassLoader(), new Class[0]);
                event.addSerializers(serializers);
            }
        }, (Plugin)this);
    }

    public void onDisable() {
        HandlerList.unregisterAll((Plugin)this);
        Bukkit.getServer().getScheduler().cancelTasks((Plugin)this);
        debug = null;
        this.adventure.close();
        this.adventure = null;
    }

    public static MechanicsCore getPlugin() {
        return instance;
    }
}

