/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.foliascheduler.folia;

import com.cjcrafter.foliascheduler.AsyncSchedulerImplementation;
import com.cjcrafter.foliascheduler.TaskImplementation;
import com.cjcrafter.foliascheduler.folia.FoliaTask;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class FoliaAsyncScheduler
implements AsyncSchedulerImplementation {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final AsyncScheduler asyncScheduler;

    @ApiStatus.Internal
    public FoliaAsyncScheduler(@NotNull Plugin plugin) {
        this.plugin = plugin;
        this.asyncScheduler = plugin.getServer().getAsyncScheduler();
    }

    @NotNull
    private <T> Consumer<ScheduledTask> buildFoliaConsumer(@NotNull FoliaTask<T> taskImplementation, @NotNull Function<TaskImplementation<T>, T> callbackFunction) {
        return scheduledTask -> {
            taskImplementation.setScheduledTask((ScheduledTask)scheduledTask);
            taskImplementation.setCallback(callbackFunction.apply(taskImplementation));
            taskImplementation.asFuture().complete(taskImplementation);
        };
    }

    @Override
    @NotNull
    public <T> TaskImplementation<T> runNow(@NotNull Function<TaskImplementation<T>, T> function) {
        FoliaTask taskImplementation = new FoliaTask();
        Consumer<ScheduledTask> foliaConsumer = this.buildFoliaConsumer(taskImplementation, function);
        ScheduledTask scheduledTask = this.asyncScheduler.runNow(this.plugin, foliaConsumer);
        taskImplementation.setScheduledTask(scheduledTask);
        return taskImplementation;
    }

    @Override
    @NotNull
    public <T> TaskImplementation<T> runDelayed(@NotNull Function<TaskImplementation<T>, T> function, long delay, @NotNull TimeUnit unit) {
        FoliaTask taskImplementation = new FoliaTask();
        Consumer<ScheduledTask> foliaConsumer = this.buildFoliaConsumer(taskImplementation, function);
        ScheduledTask scheduledTask = this.asyncScheduler.runDelayed(this.plugin, foliaConsumer, delay, unit);
        taskImplementation.setScheduledTask(scheduledTask);
        return taskImplementation;
    }

    @Override
    @NotNull
    public <T> TaskImplementation<T> runAtFixedRate(@NotNull Function<TaskImplementation<T>, T> function, long delay, long period, @NotNull TimeUnit unit) {
        FoliaTask taskImplementation = new FoliaTask();
        Consumer<ScheduledTask> foliaConsumer = this.buildFoliaConsumer(taskImplementation, function);
        ScheduledTask scheduledTask = this.asyncScheduler.runAtFixedRate(this.plugin, foliaConsumer, delay, period, unit);
        taskImplementation.setScheduledTask(scheduledTask);
        return taskImplementation;
    }

    @Override
    public void cancelTasks() {
        this.asyncScheduler.cancelTasks(this.plugin);
    }
}

