/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.plugins;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class InterceptorIgnoreHelper {
    private static final Map<String, InterceptorIgnoreCache> INTERCEPTOR_IGNORE_CACHE = new ConcurrentHashMap<String, InterceptorIgnoreCache>();

    public static synchronized InterceptorIgnoreCache initSqlParserInfoCache(Class<?> mapperClass) {
        InterceptorIgnore ignore = mapperClass.getAnnotation(InterceptorIgnore.class);
        if (ignore != null) {
            return InterceptorIgnoreHelper.buildInterceptorIgnoreCache(ignore);
        }
        return null;
    }

    public static void initSqlParserInfoCache(InterceptorIgnoreCache mapperAnnotation, String mapperClassName, Method method) {
        InterceptorIgnore ignore = method.getAnnotation(InterceptorIgnore.class);
        String key = mapperClassName.concat(".").concat(method.getName());
        if (ignore != null) {
            InterceptorIgnoreCache methodCache = InterceptorIgnoreHelper.buildInterceptorIgnoreCache(ignore);
            if (mapperAnnotation == null) {
                INTERCEPTOR_IGNORE_CACHE.put(key, methodCache);
                return;
            }
            INTERCEPTOR_IGNORE_CACHE.put(key, InterceptorIgnoreHelper.chooseCache(mapperAnnotation, methodCache));
        } else if (mapperAnnotation != null) {
            INTERCEPTOR_IGNORE_CACHE.put(key, mapperAnnotation);
        }
    }

    public static boolean willIgnoreTenantLine(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, i -> i.getTenantLine() != null && i.getTenantLine() != false);
    }

    public static boolean willIgnoreDynamicTableName(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, i -> i.getDynamicTableName() != null && i.getDynamicTableName() != false);
    }

    public static boolean willIgnoreBlockAttack(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, i -> i.getBlockAttack() != null && i.getBlockAttack() != false);
    }

    public static boolean willIgnoreIllegalSql(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, i -> i.getIllegalSql() != null && i.getIllegalSql() != false);
    }

    public static boolean willIgnore(String id, Function<InterceptorIgnoreCache, Boolean> function) {
        InterceptorIgnoreCache cache = INTERCEPTOR_IGNORE_CACHE.get(id);
        if (cache != null) {
            return function.apply(cache);
        }
        return false;
    }

    private static InterceptorIgnoreCache chooseCache(InterceptorIgnoreCache mapper, InterceptorIgnoreCache method) {
        return InterceptorIgnoreCache.builder().tenantLine(InterceptorIgnoreHelper.chooseBoolean(mapper.getTenantLine(), method.getTenantLine())).dynamicTableName(InterceptorIgnoreHelper.chooseBoolean(mapper.getDynamicTableName(), method.getDynamicTableName())).blockAttack(InterceptorIgnoreHelper.chooseBoolean(mapper.getBlockAttack(), method.getBlockAttack())).illegalSql(InterceptorIgnoreHelper.chooseBoolean(mapper.getIllegalSql(), method.getIllegalSql())).build();
    }

    private static InterceptorIgnoreCache buildInterceptorIgnoreCache(InterceptorIgnore ignore) {
        return InterceptorIgnoreCache.builder().tenantLine(InterceptorIgnoreHelper.getBoolean(ignore.tenantLine())).dynamicTableName(InterceptorIgnoreHelper.getBoolean(ignore.dynamicTableName())).blockAttack(InterceptorIgnoreHelper.getBoolean(ignore.blockAttack())).illegalSql(InterceptorIgnoreHelper.getBoolean(ignore.illegalSql())).build();
    }

    private static Boolean getBoolean(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        if ("1".equals(value) || "true".equals(value) || "on".equals(value)) {
            return true;
        }
        if ("0".equals(value) || "false".equals(value) || "off".equals(value)) {
            return false;
        }
        throw ExceptionUtils.mpe("not support this value of \"%s\"", value);
    }

    private static Boolean chooseBoolean(Boolean mapper, Boolean method) {
        if (mapper == null && method == null) {
            return null;
        }
        if (method != null) {
            return method;
        }
        return mapper;
    }

    public static class InterceptorIgnoreCache {
        private Boolean tenantLine;
        private Boolean dynamicTableName;
        private Boolean blockAttack;
        private Boolean illegalSql;

        InterceptorIgnoreCache(Boolean tenantLine, Boolean dynamicTableName, Boolean blockAttack, Boolean illegalSql) {
            this.tenantLine = tenantLine;
            this.dynamicTableName = dynamicTableName;
            this.blockAttack = blockAttack;
            this.illegalSql = illegalSql;
        }

        public static InterceptorIgnoreCacheBuilder builder() {
            return new InterceptorIgnoreCacheBuilder();
        }

        public Boolean getTenantLine() {
            return this.tenantLine;
        }

        public Boolean getDynamicTableName() {
            return this.dynamicTableName;
        }

        public Boolean getBlockAttack() {
            return this.blockAttack;
        }

        public Boolean getIllegalSql() {
            return this.illegalSql;
        }

        public void setTenantLine(Boolean tenantLine) {
            this.tenantLine = tenantLine;
        }

        public void setDynamicTableName(Boolean dynamicTableName) {
            this.dynamicTableName = dynamicTableName;
        }

        public void setBlockAttack(Boolean blockAttack) {
            this.blockAttack = blockAttack;
        }

        public void setIllegalSql(Boolean illegalSql) {
            this.illegalSql = illegalSql;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InterceptorIgnoreCache)) {
                return false;
            }
            InterceptorIgnoreCache other = (InterceptorIgnoreCache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$tenantLine = this.getTenantLine();
            Boolean other$tenantLine = other.getTenantLine();
            if (this$tenantLine == null ? other$tenantLine != null : !((Object)this$tenantLine).equals(other$tenantLine)) {
                return false;
            }
            Boolean this$dynamicTableName = this.getDynamicTableName();
            Boolean other$dynamicTableName = other.getDynamicTableName();
            if (this$dynamicTableName == null ? other$dynamicTableName != null : !((Object)this$dynamicTableName).equals(other$dynamicTableName)) {
                return false;
            }
            Boolean this$blockAttack = this.getBlockAttack();
            Boolean other$blockAttack = other.getBlockAttack();
            if (this$blockAttack == null ? other$blockAttack != null : !((Object)this$blockAttack).equals(other$blockAttack)) {
                return false;
            }
            Boolean this$illegalSql = this.getIllegalSql();
            Boolean other$illegalSql = other.getIllegalSql();
            return !(this$illegalSql == null ? other$illegalSql != null : !((Object)this$illegalSql).equals(other$illegalSql));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InterceptorIgnoreCache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $tenantLine = this.getTenantLine();
            result = result * 59 + ($tenantLine == null ? 43 : ((Object)$tenantLine).hashCode());
            Boolean $dynamicTableName = this.getDynamicTableName();
            result = result * 59 + ($dynamicTableName == null ? 43 : ((Object)$dynamicTableName).hashCode());
            Boolean $blockAttack = this.getBlockAttack();
            result = result * 59 + ($blockAttack == null ? 43 : ((Object)$blockAttack).hashCode());
            Boolean $illegalSql = this.getIllegalSql();
            result = result * 59 + ($illegalSql == null ? 43 : ((Object)$illegalSql).hashCode());
            return result;
        }

        public String toString() {
            return "InterceptorIgnoreHelper.InterceptorIgnoreCache(tenantLine=" + this.getTenantLine() + ", dynamicTableName=" + this.getDynamicTableName() + ", blockAttack=" + this.getBlockAttack() + ", illegalSql=" + this.getIllegalSql() + ")";
        }

        public static class InterceptorIgnoreCacheBuilder {
            private Boolean tenantLine;
            private Boolean dynamicTableName;
            private Boolean blockAttack;
            private Boolean illegalSql;

            InterceptorIgnoreCacheBuilder() {
            }

            public InterceptorIgnoreCacheBuilder tenantLine(Boolean tenantLine) {
                this.tenantLine = tenantLine;
                return this;
            }

            public InterceptorIgnoreCacheBuilder dynamicTableName(Boolean dynamicTableName) {
                this.dynamicTableName = dynamicTableName;
                return this;
            }

            public InterceptorIgnoreCacheBuilder blockAttack(Boolean blockAttack) {
                this.blockAttack = blockAttack;
                return this;
            }

            public InterceptorIgnoreCacheBuilder illegalSql(Boolean illegalSql) {
                this.illegalSql = illegalSql;
                return this;
            }

            public InterceptorIgnoreCache build() {
                return new InterceptorIgnoreCache(this.tenantLine, this.dynamicTableName, this.blockAttack, this.illegalSql);
            }

            public String toString() {
                return "InterceptorIgnoreHelper.InterceptorIgnoreCache.InterceptorIgnoreCacheBuilder(tenantLine=" + this.tenantLine + ", dynamicTableName=" + this.dynamicTableName + ", blockAttack=" + this.blockAttack + ", illegalSql=" + this.illegalSql + ")";
            }
        }
    }
}

