/*
 * Decompiled with CFR 0.152.
 */
package com.authy.api;

import com.authy.AuthyException;
import com.authy.api.Params;
import com.authy.api.Resource;
import com.authy.api.Verification;

public class PhoneVerification
extends Resource {
    public static final String PHONE_VERIFICATION_API_PATH = "/protected/json/phones/verification/";

    public PhoneVerification(String uri, String key) {
        super(uri, key, "application/json");
    }

    public PhoneVerification(String uri, String key, boolean testFlag) {
        super(uri, key, testFlag, "application/json");
    }

    public Verification start(String phoneNumber, String countryCode, String via, Params params) throws AuthyException {
        params.setAttribute("phone_number", phoneNumber);
        params.setAttribute("country_code", countryCode);
        params.setAttribute("via", via);
        Resource.Response response = this.post("/protected/json/phones/verification/start", params);
        Verification verification = new Verification(response.getStatus(), response.getBody());
        if (!verification.isOk()) {
            verification.setError(this.errorFromJson(response.getBody()));
        }
        return verification;
    }

    public Verification check(String phoneNumber, String countryCode, String code) throws AuthyException {
        return this.check(phoneNumber, countryCode, code, new Params());
    }

    public Verification check(String phoneNumber, String countryCode, String code, Params params) throws AuthyException {
        params.setAttribute("phone_number", phoneNumber);
        params.setAttribute("country_code", countryCode);
        params.setAttribute("verification_code", code);
        Resource.Response response = this.get("/protected/json/phones/verification/check", params);
        Verification verification = new Verification(response.getStatus(), response.getBody());
        if (!verification.isOk()) {
            verification.setError(this.errorFromJson(response.getBody()));
        }
        return verification;
    }
}

