/*
 * Decompiled with CFR 0.152.
 */
package com.authy.api;

import com.authy.AuthyException;
import com.authy.api.Error;
import com.authy.api.Formattable;
import com.authy.api.Hash;
import com.authy.api.Resource;
import com.authy.api.Token;
import java.io.StringReader;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONObject;

public class Tokens
extends Resource {
    public static final String TOKEN_VERIFICATION_PATH = "/protected/xml/verify/";

    public Tokens(String uri, String key) {
        super(uri, key);
    }

    public Tokens(String uri, String key, boolean testFlag) {
        super(uri, key, testFlag);
    }

    public Token verify(int userId, String token) {
        return this.verify(userId, token, null);
    }

    public Token verify(int userId, String token, Map<String, String> options) {
        InternalToken internalToken = new InternalToken();
        internalToken.setOption(options);
        StringBuilder path = new StringBuilder(TOKEN_VERIFICATION_PATH);
        try {
            this.validateToken(token);
            path.append(URLEncoder.encode(token, "UTF-8")).append('/');
            path.append(URLEncoder.encode(Integer.toString(userId), "UTF-8"));
            String content = this.get(path.toString(), internalToken);
            return this.tokenFromXml(this.getStatus(), content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Token();
        }
    }

    private Token tokenFromXml(int status, String content) {
        Token token = new Token();
        try {
            Error error = this.errorFromXml(status, content);
            if (error != null) {
                token.setError(error);
                return token;
            }
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Hash.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StringReader xml = new StringReader(content);
            Hash hash = (Hash)unmarshaller.unmarshal((Source)new StreamSource(xml));
            token = new Token(status, content, hash.getMessage());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return token;
    }

    private Error errorFromXml(int status, String content) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Error.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StringReader xml = new StringReader(content);
            Error error = (Error)unmarshaller.unmarshal((Source)new StreamSource(xml));
            return error;
        }
        catch (JAXBException e) {
            return null;
        }
    }

    private void validateToken(String token) throws AuthyException {
        int len = token.length();
        if (!this.isInteger(token)) {
            throw new AuthyException("Invalid Token. Only digits accepted.");
        }
        if (len < 6 || len > 10) {
            throw new AuthyException("Invalid Token. Unexpected length.");
        }
    }

    private boolean isInteger(String s) {
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    class InternalToken
    implements Formattable {
        Map<String, String> options = new HashMap<String, String>();

        public void setOption(Map<String, String> options) {
            if (options != null) {
                this.options = options;
            }
        }

        @Override
        public String toXML() {
            return null;
        }

        @Override
        public Map<String, String> toMap() {
            if (!this.options.containsKey("force")) {
                this.options.put("force", "true");
            }
            return this.options;
        }

        @Override
        public String toJSON() {
            return new JSONObject(this.toMap()).toString();
        }
    }
}

