/*
 * Decompiled with CFR 0.152.
 */
package com.authy.api;

import com.authy.OneTouchException;
import org.json.JSONException;
import org.json.JSONObject;

public class OneTouchResponse {
    private JSONObject obj;

    public OneTouchResponse(String json) throws OneTouchException {
        this.init(json);
    }

    private void init(String json) throws OneTouchException {
        try {
            this.obj = new JSONObject(json);
        }
        catch (JSONException ex) {
            throw new OneTouchException("Invalid JSON format, the given string is not a valid json object.", ex);
        }
    }

    public boolean isSuccess() {
        return this.obj.has("success") && this.obj.getBoolean("success");
    }

    public String getMessage() {
        return this.obj.has("message") ? this.obj.getString("message") : "";
    }

    public String getErrorCode() {
        return this.obj.has("error_code") ? this.obj.getString("error_code") : "";
    }

    public ApprovalRequest getApprovalRequest() {
        if (this.obj.has("approval_request")) {
            return new ApprovalRequest();
        }
        return null;
    }

    public class ApprovalRequest {
        private ApprovalRequest() {
        }

        public boolean isNotified() {
            return OneTouchResponse.this.obj.getJSONObject("approval_request").has("notified") && OneTouchResponse.this.obj.getJSONObject("approval_request").getBoolean("notified");
        }

        public String createdAt() {
            return OneTouchResponse.this.obj.getJSONObject("approval_request").has("created_at") ? OneTouchResponse.this.obj.getJSONObject("approval_request").getString("created_at") : null;
        }

        public String getUUID() {
            return OneTouchResponse.this.obj.getJSONObject("approval_request").has("uuid") ? OneTouchResponse.this.obj.getJSONObject("approval_request").getString("uuid") : null;
        }

        public String getStatus() {
            return OneTouchResponse.this.obj.getJSONObject("approval_request").has("status") ? OneTouchResponse.this.obj.getJSONObject("approval_request").getString("status") : null;
        }

        public String getValue(String key) {
            return OneTouchResponse.this.obj.getJSONObject("approval_request").has(key) ? OneTouchResponse.this.obj.getJSONObject("approval_request").getString(key) : null;
        }
    }
}

