/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.kernel;

import com.alipay.easysdk.kernel.AlipayConstants;
import com.alipay.easysdk.kernel.Context;
import com.alipay.easysdk.kernel.util.AES;
import com.alipay.easysdk.kernel.util.JsonUtil;
import com.alipay.easysdk.kernel.util.MultipartUtil;
import com.alipay.easysdk.kernel.util.PageUtil;
import com.alipay.easysdk.kernel.util.SignContentExtractor;
import com.alipay.easysdk.kernel.util.Signer;
import com.aliyun.tea.TeaResponse;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(Client.class);
    private final Context context;
    private final Map<String, String> optionalTextParams = new HashMap<String, String>();
    private final Map<String, Object> optionalBizParams = new HashMap<String, Object>();

    public Client(Context context) {
        this.context = context;
    }

    public Client injectTextParam(String key, String value) {
        this.optionalTextParams.put(key, value);
        return this;
    }

    public Client injectBizParam(String key, Object value) {
        this.optionalBizParams.put(key, value);
        return this;
    }

    public String getTimestamp() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        return df.format(new Date());
    }

    public String getConfig(String key) throws Exception {
        return this.context.getConfig(key);
    }

    public String getSdkVersion() throws Exception {
        return this.context.getSdkVersion();
    }

    public byte[] toUrlEncodedRequestBody(Map<String, ?> bizParams) throws Exception {
        Map<String, String> sortedMap = this.getSortedMap(Collections.emptyMap(), bizParams, null);
        return this.buildQueryString(sortedMap).getBytes(AlipayConstants.DEFAULT_CHARSET);
    }

    public Map<String, Object> readAsJson(TeaResponse response, String method) throws Exception {
        String responseBody = response.getResponseBody();
        Map map = (Map)new Gson().fromJson(responseBody, Map.class);
        map.put("http_body", responseBody);
        map.put("method", method);
        this.closeConnection(response);
        return map;
    }

    private void closeConnection(TeaResponse response) {
        if (response.getResponse() != null) {
            try {
                response.getResponse().close();
            }
            catch (IOException e) {
                LOGGER.warn("\u5173\u95ed\u94fe\u63a5\u906d\u9047\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public Map<String, Object> toRespModel(Map<String, Object> respMap) throws Exception {
        String methodName = (String)respMap.get("method");
        String responseNodeName = methodName.replace('.', '_') + "_response";
        String errorNodeName = "error_response";
        for (Map.Entry<String, Object> pair : respMap.entrySet()) {
            if (!responseNodeName.equals(pair.getKey())) continue;
            Map model = (Map)pair.getValue();
            model.put("http_body", respMap.get("http_body"));
            return model;
        }
        for (Map.Entry<String, Object> pair : respMap.entrySet()) {
            if (!errorNodeName.equals(pair.getKey())) continue;
            Map model = (Map)pair.getValue();
            model.put("http_body", respMap.get("http_body"));
            return model;
        }
        throw new RuntimeException("\u54cd\u5e94\u683c\u5f0f\u4e0d\u7b26\u5408\u9884\u671f\uff0c\u627e\u4e0d\u5230" + responseNodeName + "\u6216" + errorNodeName + "\u8282\u70b9");
    }

    public String getRandomBoundary() throws Exception {
        return System.currentTimeMillis() + "";
    }

    public InputStream toMultipartRequestBody(Map<String, String> textParams, Map<String, String> fileParams, String boundary) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.addOtherParams(textParams, null);
        for (Map.Entry<String, String> pair : textParams.entrySet()) {
            if (Strings.isNullOrEmpty((String)pair.getKey()) || Strings.isNullOrEmpty((String)pair.getValue())) continue;
            stream.write(MultipartUtil.getEntryBoundary(boundary));
            stream.write(MultipartUtil.getTextEntry(pair.getKey(), pair.getValue()));
        }
        for (Map.Entry<String, String> pair : fileParams.entrySet()) {
            if (Strings.isNullOrEmpty((String)pair.getKey()) || pair.getValue() == null) continue;
            stream.write(MultipartUtil.getEntryBoundary(boundary));
            stream.write(MultipartUtil.getFileEntry(pair.getKey(), pair.getValue()));
            stream.write(Files.toByteArray((File)new File(pair.getValue())));
        }
        stream.write(MultipartUtil.getEndBoundary(boundary));
        return new ByteArrayInputStream(stream.toByteArray());
    }

    private void addOtherParams(Map<String, String> textParams, Map<String, ?> bizParams) throws Exception {
        if (textParams != null) {
            for (Map.Entry<String, Object> entry : this.optionalTextParams.entrySet()) {
                if (textParams.containsKey(entry.getKey())) continue;
                textParams.put(entry.getKey(), (String)entry.getValue());
            }
            this.setNotifyUrl(textParams);
        }
        if (bizParams != null) {
            for (Map.Entry<String, Object> entry : this.optionalBizParams.entrySet()) {
                if (bizParams.containsKey(entry.getKey())) continue;
                bizParams.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public String generatePage(String method, Map<String, String> systemParams, Map<String, ?> bizParams, Map<String, String> textParams, String sign) throws Exception {
        if ("GET".equalsIgnoreCase(method)) {
            Map<String, String> sortedMap = this.getSortedMap(systemParams, bizParams, textParams);
            sortedMap.put("sign", sign);
            return this.getGatewayServerUrl() + "?" + this.buildQueryString(sortedMap);
        }
        if ("POST".equalsIgnoreCase(method)) {
            Map<String, String> urlParams = this.getSortedMap(systemParams, null, textParams);
            urlParams.put("sign", sign);
            String actionUrl = this.getGatewayServerUrl() + "?" + this.buildQueryString(urlParams);
            this.addOtherParams(null, bizParams);
            TreeMap<String, String> formParams = new TreeMap<String, String>();
            formParams.put("biz_content", JsonUtil.toJsonString(bizParams));
            return PageUtil.buildForm(actionUrl, formParams);
        }
        throw new RuntimeException("_generatePage\u4e2dmethod\u53ea\u652f\u6301\u4f20\u5165GET\u6216POST");
    }

    public String getMerchantCertSN() throws Exception {
        if (this.context.getCertEnvironment() == null) {
            return null;
        }
        return this.context.getCertEnvironment().getMerchantCertSN();
    }

    public String getAlipayCertSN(Map<String, Object> respMap) throws Exception {
        return (String)respMap.get("alipay_cert_sn");
    }

    public String getAlipayRootCertSN() throws Exception {
        if (this.context.getCertEnvironment() == null) {
            return null;
        }
        return this.context.getCertEnvironment().getRootCertSN();
    }

    public Boolean isCertMode() throws Exception {
        return this.context.getCertEnvironment() != null;
    }

    public String extractAlipayPublicKey(String alipayCertSN) throws Exception {
        if (this.context.getCertEnvironment() == null) {
            return null;
        }
        return this.context.getCertEnvironment().getAlipayPublicKey(alipayCertSN);
    }

    public Boolean verify(Map<String, Object> respMap, String alipayPublicKey) throws Exception {
        String sign = (String)respMap.get("sign");
        String content = SignContentExtractor.getSignSourceData((String)respMap.get("http_body"), (String)respMap.get("method"));
        return Signer.verify(content, sign, alipayPublicKey);
    }

    public String sign(Map<String, String> systemParams, Map<String, ?> bizParams, Map<String, String> textParams, String merchantPrivateKey) throws Exception {
        Map<String, String> sortedMap = this.getSortedMap(systemParams, bizParams, textParams);
        StringBuilder content = new StringBuilder();
        int index = 0;
        for (Map.Entry<String, String> pair : sortedMap.entrySet()) {
            if (Strings.isNullOrEmpty((String)pair.getKey()) || Strings.isNullOrEmpty((String)pair.getValue())) continue;
            content.append(index == 0 ? "" : "&").append(pair.getKey()).append("=").append(pair.getValue());
            ++index;
        }
        return this.context.getSigner().sign(content.toString(), merchantPrivateKey);
    }

    public Map<String, String> sortMap(Map<String, String> input) throws Exception {
        return input;
    }

    public String aesEncrypt(String plainText, String key) throws Exception {
        return AES.encrypt(plainText, key);
    }

    public String aesDecrypt(String cipherText, String key) throws Exception {
        return AES.decrypt(cipherText, key);
    }

    public String generateOrderString(Map<String, String> systemParams, Map<String, Object> bizParams, Map<String, String> textParams, String sign) throws Exception {
        Map<String, String> sortedMap = this.getSortedMap(systemParams, bizParams, textParams);
        sortedMap.put("sign", sign);
        return this.buildQueryString(sortedMap);
    }

    public Boolean verifyParams(Map<String, String> parameters, String publicKey) throws Exception {
        return Signer.verifyParams(parameters, publicKey);
    }

    private Map<String, String> getSortedMap(Map<String, String> systemParams, Map<String, ?> bizParams, Map<String, String> textParams) throws Exception {
        this.addOtherParams(textParams, bizParams);
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(systemParams);
        if (bizParams != null && !bizParams.isEmpty()) {
            sortedMap.put("biz_content", JsonUtil.toJsonString(bizParams));
        }
        if (textParams != null) {
            sortedMap.putAll(textParams);
        }
        return sortedMap;
    }

    private void setNotifyUrl(Map<String, String> params) throws Exception {
        if (this.getConfig("notifyUrl") != null && !params.containsKey("notify_url")) {
            params.put("notify_url", this.getConfig("notifyUrl"));
        }
    }

    public String concatStr(String a, String b) {
        return a + b;
    }

    private String buildQueryString(Map<String, String> sortedMap) throws UnsupportedEncodingException {
        StringBuilder content = new StringBuilder();
        int index = 0;
        for (Map.Entry<String, String> pair : sortedMap.entrySet()) {
            if (Strings.isNullOrEmpty((String)pair.getKey()) || Strings.isNullOrEmpty((String)pair.getValue())) continue;
            content.append(index == 0 ? "" : "&").append(pair.getKey()).append("=").append(URLEncoder.encode(pair.getValue(), AlipayConstants.DEFAULT_CHARSET.name()));
            ++index;
        }
        return content.toString();
    }

    private String getGatewayServerUrl() throws Exception {
        return this.getConfig("protocol") + "://" + this.getConfig("gatewayHost") + "/gateway.do";
    }
}

