/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.api;

import com.alibaba.dashscope.base.HalfDuplexParamBase;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.TaskStatus;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.AsyncTaskOption;
import com.alibaba.dashscope.protocol.ClientProviders;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.HalfDuplexClient;
import com.alibaba.dashscope.protocol.HalfDuplexRequest;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.ServiceOption;
import com.alibaba.dashscope.task.AsyncTaskListParam;
import com.alibaba.dashscope.task.AsyncTaskParam;
import com.google.gson.JsonObject;

public final class AsynchronousApi<ParamT extends HalfDuplexParamBase> {
    final HalfDuplexClient client;
    ConnectionOptions connectionOptions;

    public AsynchronousApi() {
        this.client = ClientProviders.getHalfDuplexClient("https");
        this.connectionOptions = null;
    }

    public AsynchronousApi(ConnectionOptions connectionOptions) {
        this.client = ClientProviders.getHalfDuplexClient(connectionOptions, "https");
        this.connectionOptions = connectionOptions;
    }

    public DashScopeResult call(ParamT param, ServiceOption serviceOption) throws ApiException, NoApiKeyException {
        DashScopeResult task = this.asyncCall(param, serviceOption);
        return this.wait(this.getTaskId(task), ((HalfDuplexParamBase)param).getApiKey(), serviceOption.getBaseHttpUrl());
    }

    public DashScopeResult asyncCall(ParamT param, ServiceOption serviceOption) throws ApiException, NoApiKeyException {
        HalfDuplexRequest req = new HalfDuplexRequest((HalfDuplexParamBase)param, serviceOption);
        return this.client.send(req);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DashScopeResult wait(String taskId, String apiKey, String baseUrl) throws ApiException, NoApiKeyException {
        Object serviceOption = ((AsyncTaskOption.AsyncTaskOptionBuilder)((AsyncTaskOption.AsyncTaskOptionBuilder)((AsyncTaskOption.AsyncTaskOptionBuilder)((AsyncTaskOption.AsyncTaskOptionBuilder)AsyncTaskOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.GET)).url(String.format("/tasks/%s", taskId))).baseHttpUrl(baseUrl)).build();
        HalfDuplexParamBase getParam = ((AsyncTaskParam.AsyncTaskParamBuilder)((HalfDuplexParamBase.HalfDuplexParamBaseBuilder)AsyncTaskParam.builder().taskId(taskId)).apiKey(apiKey)).build();
        HalfDuplexRequest req = new HalfDuplexRequest(getParam, (ServiceOption)serviceOption);
        int waitMilliseconds = 1000;
        int maxWaitMilliseconds = 5000;
        int incrementSteps = 3;
        int step = 0;
        block4: while (true) {
            try {
                while (true) {
                    DashScopeResult taskResult;
                    JsonObject output;
                    String taskStatus;
                    String string = taskStatus = (output = (JsonObject)(taskResult = this.client.send(req)).getOutput()).get("task_status") == null ? null : output.get("task_status").getAsString();
                    if (TaskStatus.FAILED.getValue().equals(taskStatus) || TaskStatus.CANCELED.getValue().equals(taskStatus) || TaskStatus.UNKNOWN.getValue().equals(taskStatus)) {
                        return taskResult;
                    }
                    if (TaskStatus.SUCCEEDED.getValue().equals(taskStatus)) {
                        return taskResult;
                    }
                    if (waitMilliseconds < maxWaitMilliseconds && ++step % incrementSteps == 0) {
                        waitMilliseconds = waitMilliseconds * 2 > maxWaitMilliseconds ? maxWaitMilliseconds : waitMilliseconds * 2;
                    }
                    try {
                        Thread.sleep(waitMilliseconds);
                        continue block4;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (ApiException e) {
                if (e.getStatus().getStatusCode() != 503 && e.getStatus().getStatusCode() != 504) throw e;
                continue;
            }
            break;
        }
    }

    public DashScopeResult wait(DashScopeResult taskInfo, String apiKey, String baseUrl) throws ApiException, NoApiKeyException {
        return this.wait(this.getTaskId(taskInfo), apiKey, baseUrl);
    }

    public DashScopeResult fetch(String taskId, String apiKey, String baseUrl) throws ApiException, NoApiKeyException {
        Object serviceOption = ((AsyncTaskOption.AsyncTaskOptionBuilder)((AsyncTaskOption.AsyncTaskOptionBuilder)((AsyncTaskOption.AsyncTaskOptionBuilder)((AsyncTaskOption.AsyncTaskOptionBuilder)AsyncTaskOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.GET)).baseHttpUrl(baseUrl)).url(String.format("/tasks/%s", taskId))).build();
        HalfDuplexParamBase getParam = ((AsyncTaskParam.AsyncTaskParamBuilder)((HalfDuplexParamBase.HalfDuplexParamBaseBuilder)AsyncTaskParam.builder().taskId(taskId)).apiKey(apiKey)).build();
        HalfDuplexRequest req = new HalfDuplexRequest(getParam, (ServiceOption)serviceOption);
        DashScopeResult taskResult = this.client.send(req);
        return taskResult;
    }

    public DashScopeResult fetch(DashScopeResult taskInfo, String apiKey, String baseUrl) throws ApiException, NoApiKeyException {
        return this.fetch(this.getTaskId(taskInfo), apiKey, baseUrl);
    }

    public DashScopeResult cancel(String taskId, String apiKey, String baseUrl) throws ApiException, NoApiKeyException {
        HalfDuplexParamBase param = ((AsyncTaskParam.AsyncTaskParamBuilder)((HalfDuplexParamBase.HalfDuplexParamBaseBuilder)AsyncTaskParam.builder().taskId(taskId)).apiKey(apiKey)).build();
        Object taskOption = ((AsyncTaskOption.AsyncTaskOptionBuilder)((AsyncTaskOption.AsyncTaskOptionBuilder)AsyncTaskOption.builder().baseHttpUrl(baseUrl)).url(String.format("/tasks/%s/cancel", taskId))).build();
        DashScopeResult result = this.client.send(new HalfDuplexRequest(param, (ServiceOption)taskOption));
        return result;
    }

    public DashScopeResult cancel(DashScopeResult taskInfo, String apiKey, String baseUrl) throws ApiException, NoApiKeyException {
        return this.cancel(this.getTaskId(taskInfo), apiKey, baseUrl);
    }

    public DashScopeResult list(AsyncTaskListParam param, String baseUrl) throws ApiException, NoApiKeyException {
        Object taskOption = ((AsyncTaskOption.AsyncTaskOptionBuilder)((AsyncTaskOption.AsyncTaskOptionBuilder)((AsyncTaskOption.AsyncTaskOptionBuilder)AsyncTaskOption.builder().baseHttpUrl(baseUrl)).url("/tasks")).httpMethod(HttpMethod.GET)).build();
        DashScopeResult result = this.client.send(new HalfDuplexRequest(param, (ServiceOption)taskOption));
        return result;
    }

    public DashScopeResult list(String startTime, String endTime, String modelName, String apiKeyId, String region, String status, Integer pageNo, Integer pageSize, String baseUrl) throws ApiException, NoApiKeyException {
        AsyncTaskListParam.AsyncTaskListParamBuilder<?, ?> builder = AsyncTaskListParam.builder();
        if (startTime != null) {
            builder.parameter("start_time", startTime);
        }
        if (endTime != null) {
            builder.parameter("end_time", endTime);
        }
        if (modelName != null) {
            builder.parameter("model_name", modelName);
        }
        if (apiKeyId != null) {
            builder.parameter("api_key_id", apiKeyId);
        }
        if (region != null) {
            builder.parameter("region", region);
        }
        if (status != null) {
            builder.parameter("status", status);
        }
        if (pageNo != null) {
            builder.parameter("page_no", pageNo);
        }
        if (pageSize != null) {
            builder.parameter("page_size", pageSize);
        }
        HalfDuplexParamBase param = builder.build();
        return this.list((AsyncTaskListParam)param, baseUrl);
    }

    public String getTaskId(DashScopeResult task) {
        JsonObject output = (JsonObject)task.getOutput();
        return output.get("task_id").getAsString();
    }
}

