/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.okhttps;

import cn.zhxu.okhttps.OkHttpsException;
import cn.zhxu.okhttps.Platform;
import cn.zhxu.okhttps.TaskExecutor;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.function.Consumer;

public class Download {
    private final File file;
    private final InputStream input;
    private final TaskExecutor taskExecutor;
    private final Ctrl ctrl;
    private Consumer<File> onSuccess;
    private Consumer<Failure> onFailure;
    private Consumer<Status> onComplete;
    private long doneBytes;
    private int buffSize = 0;
    private long seekBytes = 0L;
    private boolean appended;
    private volatile Status status;
    private final Object lock = new Object();
    protected boolean nextOnIO = false;
    private boolean sOnIO;
    private boolean fOnIO;
    private boolean cOnIO;

    public Download(File file, InputStream input, TaskExecutor taskExecutor, long skipBytes) {
        this.file = file;
        this.input = input;
        this.taskExecutor = taskExecutor;
        this.seekBytes = skipBytes;
        this.ctrl = new Ctrl();
    }

    public Download setBuffSize(int buffSize) {
        if (buffSize > 0) {
            this.buffSize = buffSize;
        }
        return this;
    }

    public Download setAppended() {
        this.appended = true;
        return this;
    }

    public Download setFilePointer(long seekBytes) {
        this.seekBytes = seekBytes;
        return this;
    }

    public Download nextOnIO() {
        this.nextOnIO = true;
        return this;
    }

    public Download setOnSuccess(Consumer<File> onSuccess) {
        this.onSuccess = onSuccess;
        this.sOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public Download setOnFailure(Consumer<Failure> onFailure) {
        this.onFailure = onFailure;
        this.fOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public Download setOnComplete(Consumer<Status> onComplete) {
        this.onComplete = onComplete;
        this.cOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public Ctrl start() {
        RandomAccessFile raFile;
        if (this.buffSize == 0) {
            this.buffSize = 8192;
        }
        if ((raFile = this.randomAccessFile()) != null) {
            this.status = Status.DOWNLOADING;
            this.taskExecutor.execute(() -> this.doDownload(raFile), true);
        }
        return this.ctrl;
    }

    public Ctrl getCtrl() {
        return this.ctrl;
    }

    private RandomAccessFile randomAccessFile() {
        try {
            return new RandomAccessFile(this.file, "rw");
        }
        catch (FileNotFoundException e) {
            this.status = Status.ERROR;
            Download.closeQuietly(this.input);
            this.fireOnComplete();
            this.fireOnFailure(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doDownload(RandomAccessFile raFile) {
        try {
            if (this.appended && this.seekBytes > 0L) {
                raFile.seek(this.seekBytes);
            }
            while (this.status != Status.CANCELED && this.status != Status.DONE) {
                int len;
                if (this.status != Status.DOWNLOADING) continue;
                byte[] buff = new byte[this.buffSize];
                while ((len = this.input.read(buff)) != -1) {
                    raFile.write(buff, 0, len);
                    this.doneBytes += (long)len;
                    if (this.status != Status.CANCELED && this.status != Status.PAUSED) continue;
                }
                if (len != -1) continue;
                Object object = this.lock;
                // MONITORENTER : object
                if (this.status != Status.CANCELED) {
                    this.status = Status.DONE;
                }
                // MONITOREXIT : object
            }
        }
        catch (IOException e) {
            Object object = this.lock;
            // MONITORENTER : object
            if (this.status != Status.CANCELED) {
                this.status = Status.ERROR;
            }
            // MONITOREXIT : object
            if (this.status == Status.ERROR) {
                this.fireOnFailure(e);
            }
        }
        finally {
            Download.closeQuietly(raFile);
            Download.closeQuietly(this.input);
            if (this.status == Status.CANCELED && !this.file.delete()) {
                Platform.logError("can not delete canceled file: " + this.file);
            }
            this.fireOnComplete();
        }
        if (this.status != Status.DONE) return;
        this.fireOnSuccess();
    }

    private void fireOnComplete() {
        Consumer<Status> onComplete = this.onComplete;
        if (onComplete != null) {
            this.taskExecutor.execute(() -> onComplete.accept(this.status), this.cOnIO);
        }
    }

    private void fireOnSuccess() {
        Consumer<File> onSuccess = this.onSuccess;
        if (onSuccess != null) {
            this.taskExecutor.execute(() -> onSuccess.accept(this.file), this.sOnIO);
        }
    }

    private void fireOnFailure(IOException e) {
        Consumer<Failure> onFailure = this.onFailure;
        if (onFailure == null) {
            throw new OkHttpsException("Download failed: ", e);
        }
        this.taskExecutor.execute(() -> onFailure.accept(new Failure(e)), this.fOnIO);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum Status {
        CANCELED(-1),
        DOWNLOADING(1),
        PAUSED(2),
        DONE(3),
        ERROR(4);

        private final int value;

        private Status(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public class Ctrl {
        public Status status() {
            return Download.this.status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean pause() {
            Object object = Download.this.lock;
            synchronized (object) {
                if (Download.this.status == Status.DOWNLOADING) {
                    Download.this.status = Status.PAUSED;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean resume() {
            Object object = Download.this.lock;
            synchronized (object) {
                if (Download.this.status == Status.PAUSED) {
                    Download.this.status = Status.DOWNLOADING;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            Object object = Download.this.lock;
            synchronized (object) {
                if (Download.this.status == Status.PAUSED || Download.this.status == Status.DOWNLOADING) {
                    Download.this.status = Status.CANCELED;
                    return true;
                }
            }
            return false;
        }
    }

    public class Failure {
        private final IOException exception;

        Failure(IOException exception) {
            this.exception = exception;
        }

        public File getFile() {
            return Download.this.file;
        }

        public long getDoneBytes() {
            return Download.this.doneBytes;
        }

        public IOException getException() {
            return this.exception;
        }
    }
}

