/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.config.SaSsoConfig;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.sso.SaSsoConsts;
import cn.dev33.satoken.sso.SaSsoUtil;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;

public class SaSsoHandle {
    public static Object serverRequest() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoConfig sso = SaManager.getConfig().getSso();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        if (req.isPath(SaSsoConsts.Api.ssoAuth)) {
            if (!stpLogic.isLogin()) {
                return sso.notLoginView.get();
            }
            String redirectUrl = SaSsoUtil.buildRedirectUrl(stpLogic.getLoginId(), req.getParam(SaSsoConsts.ParamName.redirect));
            return res.redirect(redirectUrl);
        }
        if (req.isPath(SaSsoConsts.Api.ssoDoLogin)) {
            return sso.doLoginHandle.apply(req.getParam("name"), req.getParam("pwd"));
        }
        if (req.isPath(SaSsoConsts.Api.ssoCheckTicket) && sso.isHttp.booleanValue()) {
            String ticket = req.getParam(SaSsoConsts.ParamName.ticket);
            String sloCallback = req.getParam(SaSsoConsts.ParamName.ssoLogoutCall);
            Object loginId = SaSsoUtil.checkTicket(ticket);
            SaSsoUtil.registerSloCallbackUrl(loginId, sloCallback);
            return loginId;
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogout) && sso.isSlo.booleanValue()) {
            String loginId = req.getParam(SaSsoConsts.ParamName.loginId);
            String secretkey = req.getParam(SaSsoConsts.ParamName.secretkey);
            SaSsoUtil.singleLogout(secretkey, loginId, url -> sso.sendHttp.apply(url));
            return "ok";
        }
        return "{\"msg\": \"not handle\"}";
    }

    public static Object clientRequest() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoConfig sso = SaManager.getConfig().getSso();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        if (req.isPath(SaSsoConsts.Api.ssoLogin)) {
            String back = req.getParam(SaSsoConsts.ParamName.back, "/");
            String ticket = req.getParam(SaSsoConsts.ParamName.ticket);
            if (stpLogic.isLogin()) {
                return res.redirect(back);
            }
            if (ticket == null) {
                String serverAuthUrl = SaSsoUtil.buildServerAuthUrl(SaHolder.getRequest().getUrl(), back);
                return res.redirect(serverAuthUrl);
            }
            Object loginId = null;
            if (sso.isHttp.booleanValue()) {
                String checkUrl;
                Object body;
                String ssoLogoutCall = null;
                if (sso.isSlo.booleanValue()) {
                    ssoLogoutCall = SaHolder.getRequest().getUrl().replace(SaSsoConsts.Api.ssoLogin, SaSsoConsts.Api.ssoLogoutCall);
                }
                loginId = SaFoxUtil.isEmpty(body = sso.sendHttp.apply(checkUrl = SaSsoUtil.buildCheckTicketUrl(ticket, ssoLogoutCall))) ? null : body;
            } else {
                loginId = SaSsoUtil.checkTicket(ticket);
            }
            if (loginId != null) {
                stpLogic.login(loginId);
                return res.redirect(back);
            }
            return sso.ticketInvalidView.apply(ticket);
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogout) && sso.isSlo.booleanValue() && !sso.isHttp.booleanValue()) {
            stpLogic.logout();
            if (req.getParam(SaSsoConsts.ParamName.back) == null) {
                return SaResult.ok("\u5355\u70b9\u6ce8\u9500\u6210\u529f");
            }
            return res.redirect(req.getParam(SaSsoConsts.ParamName.back, "/"));
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogout) && sso.isSlo.booleanValue() && sso.isHttp.booleanValue()) {
            if (!stpLogic.isLogin()) {
                return SaResult.ok();
            }
            String url = SaSsoUtil.buildSloUrl(stpLogic.getLoginId());
            String body = String.valueOf(sso.sendHttp.apply(url));
            if ("ok".equals(body)) {
                if (req.getParam(SaSsoConsts.ParamName.back) == null) {
                    return SaResult.ok("\u5355\u70b9\u6ce8\u9500\u6210\u529f");
                }
                return res.redirect(req.getParam(SaSsoConsts.ParamName.back, "/"));
            }
            return SaResult.error("\u5355\u70b9\u6ce8\u9500\u5931\u8d25");
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogoutCall) && sso.isSlo.booleanValue() && sso.isHttp.booleanValue()) {
            String loginId = req.getParam(SaSsoConsts.ParamName.loginId);
            String secretkey = req.getParam(SaSsoConsts.ParamName.secretkey);
            SaSsoUtil.checkSecretkey(secretkey);
            stpLogic.logoutByTokenValue(stpLogic.getTokenValueByLoginId(loginId));
            return "ok";
        }
        return "{\"msg\": \"not handle\"}";
    }
}

