/*
 * Decompiled with CFR 0.152.
 */
package dev.minn.jda.ktx.interactions.components;

import dev.minn.jda.ktx.interactions.components.PaginatorDefaults;
import dev.minn.jda.ktx.messages.InlineMessage;
import dev.minn.jda.ktx.messages.Mentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.GenericEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.exceptions.ErrorHandler;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.dv8tion.jda.api.hooks.EventListener;
import net.dv8tion.jda.api.hooks.SubscribeEvent;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonInteraction;
import net.dv8tion.jda.api.requests.ErrorResponse;
import net.dv8tion.jda.api.requests.restaction.interactions.MessageEditCallbackAction;
import net.dv8tion.jda.api.utils.messages.AbstractMessageBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.dv8tion.jda.api.utils.messages.MessageEditData;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u00100\u001a\u0002012\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020403\"\u000204\u00a2\u0006\u0002\u00105J\u001f\u00100\u001a\u0002012\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020!03\"\u00020!\u00a2\u0006\u0002\u00106J\u001a\u00107\u001a\u00020\u00002\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014J\u0010\u00108\u001a\u0002012\u0006\u00109\u001a\u00020:H\u0017J\u0010\u0010;\u001a\u0002012\u0006\u0010<\u001a\u00020=H\u0002R\u0014\u0010\u0007\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010\u0010R\u0014\u0010 \u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020!0'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u000e\"\u0004\b,\u0010\u0010R\u0014\u0010-\u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010#R\u0016\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010/\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006>"}, d2={"Ldev/minn/jda/ktx/interactions/components/Paginator;", "Lnet/dv8tion/jda/api/hooks/EventListener;", "nonce", "", "ttl", "Lkotlin/time/Duration;", "(Ljava/lang/String;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "controls", "Lnet/dv8tion/jda/api/interactions/components/ActionRow;", "getControls$jda_ktx", "()Lnet/dv8tion/jda/api/interactions/components/ActionRow;", "delete", "Lnet/dv8tion/jda/api/interactions/components/buttons/Button;", "getDelete", "()Lnet/dv8tion/jda/api/interactions/components/buttons/Button;", "setDelete", "(Lnet/dv8tion/jda/api/interactions/components/buttons/Button;)V", "expiresAt", "", "filter", "Lkotlin/Function1;", "Lnet/dv8tion/jda/api/interactions/components/buttons/ButtonInteraction;", "", "getFilter", "()Lkotlin/jvm/functions/Function1;", "setFilter", "(Lkotlin/jvm/functions/Function1;)V", "index", "", "next", "getNext", "setNext", "nextPage", "Lnet/dv8tion/jda/api/utils/messages/MessageCreateData;", "getNextPage", "()Lnet/dv8tion/jda/api/utils/messages/MessageCreateData;", "pageCache", "", "pages", "", "getPages", "()Ljava/util/List;", "prev", "getPrev", "setPrev", "prevPage", "getPrevPage", "J", "addPages", "", "page", "", "Lnet/dv8tion/jda/api/entities/MessageEmbed;", "([Lnet/dv8tion/jda/api/entities/MessageEmbed;)V", "([Lnet/dv8tion/jda/api/utils/messages/MessageCreateData;)V", "filterBy", "onEvent", "event", "Lnet/dv8tion/jda/api/events/GenericEvent;", "unregister", "jda", "Lnet/dv8tion/jda/api/JDA;", "jda-ktx"})
@SourceDebugExtension(value={"SMAP\nPaginator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Paginator.kt\ndev/minn/jda/ktx/interactions/components/Paginator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 builder.kt\ndev/minn/jda/ktx/messages/BuilderKt\n+ 4 builder.kt\ndev/minn/jda/ktx/messages/BuilderKt$MessageCreate$1\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,172:1\n11065#2:173\n11400#2,2:174\n11402#2:199\n62#3,9:176\n49#3,10:185\n59#3,2:196\n78#3:198\n69#4:195\n37#5,2:200\n*S KotlinDebug\n*F\n+ 1 Paginator.kt\ndev/minn/jda/ktx/interactions/components/Paginator\n*L\n87#1:173\n87#1:174,2\n87#1:199\n87#1:176,9\n87#1:185,10\n87#1:196,2\n87#1:198\n87#1:195\n87#1:200,2\n*E\n"})
public final class Paginator
implements EventListener {
    @NotNull
    private final String nonce;
    private final long ttl;
    private long expiresAt;
    private int index;
    @NotNull
    private final List<MessageCreateData> pageCache;
    @NotNull
    private Function1<? super ButtonInteraction, Boolean> filter;
    @NotNull
    private Button prev;
    @NotNull
    private Button next;
    @NotNull
    private Button delete;

    private Paginator(String nonce, long ttl) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        this.nonce = nonce;
        this.ttl = ttl;
        this.expiresAt = Math.addExact(System.currentTimeMillis(), Duration.getInWholeMilliseconds-impl((long)this.ttl));
        this.pageCache = new ArrayList();
        this.filter = Paginator::filter$lambda$0;
        this.prev = PaginatorDefaults.INSTANCE.getPREV();
        this.next = PaginatorDefaults.INSTANCE.getNEXT();
        this.delete = PaginatorDefaults.INSTANCE.getDELETE();
    }

    private final MessageCreateData getNextPage() {
        ++this.index;
        return this.pageCache.get(this.index);
    }

    private final MessageCreateData getPrevPage() {
        this.index += -1;
        return this.pageCache.get(this.index);
    }

    @NotNull
    public final Function1<ButtonInteraction, Boolean> getFilter() {
        return this.filter;
    }

    public final void setFilter(@NotNull Function1<? super ButtonInteraction, Boolean> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.filter = function1;
    }

    @NotNull
    public final Paginator filterBy(@NotNull Function1<? super ButtonInteraction, Boolean> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        this.filter = filter;
        return this;
    }

    @NotNull
    public final Button getPrev() {
        return this.prev;
    }

    public final void setPrev(@NotNull Button button2) {
        Intrinsics.checkNotNullParameter((Object)button2, (String)"<set-?>");
        this.prev = button2;
    }

    @NotNull
    public final Button getNext() {
        return this.next;
    }

    public final void setNext(@NotNull Button button2) {
        Intrinsics.checkNotNullParameter((Object)button2, (String)"<set-?>");
        this.next = button2;
    }

    @NotNull
    public final Button getDelete() {
        return this.delete;
    }

    public final void setDelete(@NotNull Button button2) {
        Intrinsics.checkNotNullParameter((Object)button2, (String)"<set-?>");
        this.delete = button2;
    }

    @NotNull
    public final ActionRow getControls$jda_ktx() {
        ItemComponent[] itemComponentArray = new ItemComponent[]{this.prev.withDisabled(this.index == 0).withId(this.nonce + ":prev"), this.next.withDisabled(this.index == this.pageCache.size() - 1).withId(this.nonce + ":next"), this.delete.withId(this.nonce + ":delete")};
        ActionRow actionRow = ActionRow.of((ItemComponent[])itemComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)actionRow, (String)"of(...)");
        return actionRow;
    }

    @NotNull
    public final List<MessageCreateData> getPages() {
        return CollectionsKt.toList((Iterable)this.pageCache);
    }

    public final void addPages(MessageCreateData ... page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        CollectionsKt.addAll((Collection)this.pageCache, (Object[])page);
    }

    /*
     * WARNING - void declaration
     */
    public final void addPages(MessageEmbed ... page) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        MessageEmbed[] messageEmbedArray = page;
        Paginator paginator = this;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            InlineMessage inlineMessage;
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Collection embeds$iv = CollectionsKt.listOf((Object)it);
            String content$iv = "";
            Collection files$iv = CollectionsKt.emptyList();
            Collection components$iv = CollectionsKt.emptyList();
            boolean tts$iv = false;
            Mentions mentions$iv = Mentions.Companion.default();
            boolean $i$f$MessageCreate = false;
            boolean $i$f$MessageCreateBuilder = false;
            MessageCreateBuilder $this$MessageCreateBuilder_u24lambda_u241$iv$iv = new MessageCreateBuilder();
            boolean bl2 = false;
            $this$MessageCreateBuilder_u24lambda_u241$iv$iv.setTTS(tts$iv);
            mentions$iv.apply((MessageRequest)$this$MessageCreateBuilder_u24lambda_u241$iv$iv);
            InlineMessage $this$MessageCreateBuilder_u24lambda_u241_u24lambda_u240$iv$iv = inlineMessage = new InlineMessage((AbstractMessageBuilder)$this$MessageCreateBuilder_u24lambda_u241$iv$iv);
            boolean bl3 = false;
            $this$MessageCreateBuilder_u24lambda_u241_u24lambda_u240$iv$iv.setContent(content$iv);
            $this$MessageCreateBuilder_u24lambda_u241_u24lambda_u240$iv$iv.getEmbeds().plusAssign(embeds$iv);
            $this$MessageCreateBuilder_u24lambda_u241_u24lambda_u240$iv$iv.getComponents().plusAssign(components$iv);
            $this$MessageCreateBuilder_u24lambda_u241_u24lambda_u240$iv$iv.getFiles().plusAssign(files$iv);
            InlineMessage inlineMessage2 = $this$MessageCreateBuilder_u24lambda_u241_u24lambda_u240$iv$iv;
            boolean bl4 = false;
            InlineMessage $this$null = inlineMessage2;
            collection.add((MessageCreateData)inlineMessage.build());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        MessageCreateData[] messageCreateDataArray = thisCollection$iv.toArray(new MessageCreateData[0]);
        paginator.addPages(Arrays.copyOf(messageCreateDataArray, messageCreateDataArray.length));
    }

    @SubscribeEvent
    public void onEvent(@NotNull GenericEvent event) {
        String operation;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.expiresAt < System.currentTimeMillis()) {
            JDA jDA = event.getJDA();
            Intrinsics.checkNotNullExpressionValue((Object)jDA, (String)"getJDA(...)");
            this.unregister(jDA);
            return;
        }
        if (!(event instanceof ButtonInteractionEvent)) {
            return;
        }
        String string = ((ButtonInteractionEvent)event).getComponentId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getComponentId(...)");
        String buttonId = string;
        if (!StringsKt.startsWith$default((String)buttonId, (String)this.nonce, (boolean)false, (int)2, null) || !((Boolean)this.filter.invoke((Object)event)).booleanValue()) {
            return;
        }
        this.expiresAt = Math.addExact(System.currentTimeMillis(), Duration.getInWholeMilliseconds-impl((long)this.ttl));
        String[] stringArray = new String[]{":"};
        switch (operation = (String)StringsKt.split$default((CharSequence)buttonId, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)) {
            case "prev": {
                LayoutComponent[] layoutComponentArray = new LayoutComponent[]{this.getControls$jda_ktx()};
                ((MessageEditCallbackAction)((ButtonInteractionEvent)event).editMessage(MessageEditData.fromCreateData((MessageCreateData)this.getPrevPage())).setComponents(layoutComponentArray)).queue(null, (Consumer)new ErrorHandler().handle(ErrorResponse.UNKNOWN_MESSAGE, arg_0 -> Paginator.onEvent$lambda$3(arg_0 -> Paginator.onEvent$lambda$2(this, event, arg_0), arg_0)));
                break;
            }
            case "next": {
                LayoutComponent[] layoutComponentArray = new LayoutComponent[]{this.getControls$jda_ktx()};
                ((MessageEditCallbackAction)((ButtonInteractionEvent)event).editMessage(MessageEditData.fromCreateData((MessageCreateData)this.getNextPage())).setComponents(layoutComponentArray)).queue(null, (Consumer)new ErrorHandler().handle(ErrorResponse.UNKNOWN_MESSAGE, arg_0 -> Paginator.onEvent$lambda$5(arg_0 -> Paginator.onEvent$lambda$4(this, event, arg_0), arg_0)));
                break;
            }
            case "delete": {
                JDA jDA = ((ButtonInteractionEvent)event).getJDA();
                Intrinsics.checkNotNullExpressionValue((Object)jDA, (String)"getJDA(...)");
                this.unregister(jDA);
                ((ButtonInteractionEvent)event).deferEdit().queue();
                ((ButtonInteractionEvent)event).getHook().deleteOriginal().queue(null, (Consumer)new ErrorHandler().ignore(ErrorResponse.UNKNOWN_MESSAGE, new ErrorResponse[0]));
            }
        }
    }

    private final void unregister(JDA jda) {
        Object[] objectArray = new Object[]{this};
        jda.removeEventListener(objectArray);
    }

    private static final boolean filter$lambda$0(ButtonInteraction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Unit onEvent$lambda$2(Paginator this$0, GenericEvent $event, ErrorResponseException it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        JDA jDA = ((ButtonInteractionEvent)$event).getJDA();
        Intrinsics.checkNotNullExpressionValue((Object)jDA, (String)"getJDA(...)");
        this$0.unregister(jDA);
        return Unit.INSTANCE;
    }

    private static final void onEvent$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit onEvent$lambda$4(Paginator this$0, GenericEvent $event, ErrorResponseException it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        JDA jDA = ((ButtonInteractionEvent)$event).getJDA();
        Intrinsics.checkNotNullExpressionValue((Object)jDA, (String)"getJDA(...)");
        this$0.unregister(jDA);
        return Unit.INSTANCE;
    }

    private static final void onEvent$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public /* synthetic */ Paginator(String nonce, long ttl, DefaultConstructorMarker $constructor_marker) {
        this(nonce, ttl);
    }
}

