/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.paper.argument;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.bukkit.internal.CraftBukkitReflection;
import cloud.commandframework.bukkit.parsers.WorldArgument;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class KeyedWorldArgument<C>
extends CommandArgument<C, World> {
    KeyedWorldArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new Parser(), defaultValue, World.class, suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull KeyedWorldArgument<C> of(@NonNull String name) {
        return ((Builder)KeyedWorldArgument.builder(name).asRequired()).build();
    }

    public static <C> @NonNull KeyedWorldArgument<C> optional(@NonNull String name) {
        return ((Builder)KeyedWorldArgument.builder(name).asOptional()).build();
    }

    public static <C> @NonNull KeyedWorldArgument<C> optional(@NonNull String name, @NonNull NamespacedKey defaultValue) {
        return KeyedWorldArgument.builder(name).asOptionalWithDefault(defaultValue).build();
    }

    public static final class Parser<C>
    implements ArgumentParser<C, World> {
        private final ArgumentParser<C, World> parser;

        public Parser() {
            Class keyed = CraftBukkitReflection.findClass((String)"org.bukkit.Keyed");
            this.parser = keyed != null && keyed.isAssignableFrom(World.class) ? null : new WorldArgument.WorldParser();
        }

        public @NonNull ArgumentParseResult<@NonNull World> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure((Throwable)new NoInputProvidedException(Parser.class, commandContext));
            }
            if (this.parser != null) {
                return this.parser.parse(commandContext, inputQueue);
            }
            NamespacedKey key = NamespacedKey.fromString((String)input);
            if (key == null) {
                return ArgumentParseResult.failure((Throwable)new WorldArgument.WorldParseException(input, commandContext));
            }
            World world = Bukkit.getWorld((NamespacedKey)key);
            if (world == null) {
                return ArgumentParseResult.failure((Throwable)new WorldArgument.WorldParseException(input, commandContext));
            }
            inputQueue.remove();
            return ArgumentParseResult.success((Object)world);
        }

        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            if (this.parser != null) {
                return this.parser.suggestions(commandContext, input);
            }
            ArrayList<String> completions = new ArrayList<String>();
            for (World world : Bukkit.getWorlds()) {
                if (world.getKey().getNamespace().equals("minecraft")) {
                    completions.add(world.getKey().getKey());
                    continue;
                }
                completions.add(world.getKey().toString());
            }
            return completions;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.TypedBuilder<C, World, Builder<C>> {
        private Builder(@NonNull String name) {
            super(World.class, name);
        }

        public @NonNull Builder<C> asOptionalWithDefault(@NonNull NamespacedKey defaultValue) {
            return (Builder)this.asOptionalWithDefault(defaultValue.toString());
        }

        public @NonNull KeyedWorldArgument<C> build() {
            return new KeyedWorldArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

