/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.arguments.standard;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.captions.StandardCaptionKeys;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.ParserException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;

@API(status=API.Status.STABLE)
public final class BooleanArgument<C>
extends CommandArgument<C, Boolean> {
    private final boolean liberal;

    private BooleanArgument(boolean required, @NonNull String name, boolean liberal, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription description) {
        super(required, name, new BooleanParser(liberal), defaultValue, Boolean.class, suggestionsProvider, description);
        this.liberal = liberal;
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return BooleanArgument.builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Boolean> of(@NonNull String name) {
        return BooleanArgument.builder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Boolean> optional(@NonNull String name) {
        return BooleanArgument.builder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Boolean> optional(@NonNull String name, boolean defaultBoolean) {
        return BooleanArgument.builder(name).asOptionalWithDefault(Boolean.toString(defaultBoolean)).build();
    }

    public boolean isLiberal() {
        return this.liberal;
    }

    @API(status=API.Status.STABLE)
    public static final class BooleanParser<C>
    implements ArgumentParser<C, Boolean> {
        private static final List<String> STRICT = Arrays.asList("TRUE", "FALSE");
        private static final List<String> LIBERAL = Arrays.asList("TRUE", "YES", "ON", "FALSE", "NO", "OFF");
        private static final List<String> LIBERAL_TRUE = Arrays.asList("TRUE", "YES", "ON");
        private static final List<String> LIBERAL_FALSE = Arrays.asList("FALSE", "NO", "OFF");
        private static final List<String> STRICT_LOWER = STRICT.stream().map((? super T s) -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
        private static final List<String> LIBERAL_LOWER = LIBERAL.stream().map((? super T s) -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
        private final boolean liberal;

        public BooleanParser(boolean liberal) {
            this.liberal = liberal;
        }

        @Override
        public @NonNull ArgumentParseResult<Boolean> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(BooleanParser.class, commandContext));
            }
            if (!this.liberal) {
                if (input.equalsIgnoreCase("true")) {
                    inputQueue.remove();
                    return ArgumentParseResult.success(true);
                }
                if (input.equalsIgnoreCase("false")) {
                    inputQueue.remove();
                    return ArgumentParseResult.success(false);
                }
                return ArgumentParseResult.failure(new BooleanParseException(input, false, commandContext));
            }
            String uppercaseInput = input.toUpperCase();
            if (LIBERAL_TRUE.contains(uppercaseInput)) {
                inputQueue.remove();
                return ArgumentParseResult.success(true);
            }
            if (LIBERAL_FALSE.contains(uppercaseInput)) {
                inputQueue.remove();
                return ArgumentParseResult.success(false);
            }
            return ArgumentParseResult.failure(new BooleanParseException(input, true, commandContext));
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            if (!this.liberal) {
                return STRICT_LOWER;
            }
            return LIBERAL_LOWER;
        }

        @Override
        public boolean isContextFree() {
            return true;
        }
    }

    @API(status=API.Status.STABLE)
    public static final class Builder<C>
    extends CommandArgument.Builder<C, Boolean> {
        private boolean liberal = false;

        private Builder(@NonNull String name) {
            super(Boolean.class, name);
        }

        public @NonNull @This Builder<C> withLiberal(boolean liberal) {
            this.liberal = liberal;
            return this;
        }

        public @NonNull BooleanArgument<C> build() {
            return new BooleanArgument(this.isRequired(), this.getName(), this.liberal, this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    @API(status=API.Status.STABLE)
    public static final class BooleanParseException
    extends ParserException {
        private static final long serialVersionUID = -2688852086944850025L;
        private final String input;
        private final boolean liberal;

        public BooleanParseException(@NonNull String input, boolean liberal, @NonNull CommandContext<?> context) {
            super(BooleanParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_BOOLEAN, CaptionVariable.of("input", input));
            this.input = input;
            this.liberal = liberal;
        }

        public @NonNull String getInput() {
            return this.input;
        }

        public boolean isLiberal() {
            return this.liberal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BooleanParseException that = (BooleanParseException)o;
            return this.liberal == that.liberal && this.input.equals(that.input);
        }

        public int hashCode() {
            return Objects.hash(this.input, this.liberal);
        }
    }
}

