/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework;

import cloud.commandframework.Command;
import cloud.commandframework.CommandManager;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.StaticArgument;
import cloud.commandframework.arguments.compound.CompoundArgument;
import cloud.commandframework.arguments.compound.FlagArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.AmbiguousNodeException;
import cloud.commandframework.exceptions.ArgumentParseException;
import cloud.commandframework.exceptions.InvalidCommandSenderException;
import cloud.commandframework.exceptions.InvalidSyntaxException;
import cloud.commandframework.exceptions.NoCommandInLeafException;
import cloud.commandframework.exceptions.NoPermissionException;
import cloud.commandframework.exceptions.NoSuchCommandException;
import cloud.commandframework.keys.CloudKey;
import cloud.commandframework.keys.SimpleCloudKey;
import cloud.commandframework.permission.CommandPermission;
import cloud.commandframework.permission.OrPermission;
import cloud.commandframework.types.tuples.Pair;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.INTERNAL, consumers={"cloud.commandframework.*"})
public final class CommandTree<C> {
    public static final CloudKey<Integer> PARSING_ARGUMENT_KEY = SimpleCloudKey.of("__parsing_argument__", TypeToken.get(Integer.class));
    private final Object commandLock = new Object();
    private final Node<CommandArgument<C, ?>> internalTree = new Node(null);
    private final CommandManager<C> commandManager;

    private CommandTree(@NonNull CommandManager<C> commandManager) {
        this.commandManager = commandManager;
    }

    public static <C> @NonNull CommandTree<C> newTree(@NonNull CommandManager<C> commandManager) {
        return new CommandTree<C>(commandManager);
    }

    public @NonNull Pair<@Nullable Command<C>, @Nullable Exception> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> args) {
        Command<C> command;
        if (this.internalTree.isLeaf() && ((Node)this.internalTree).value == null) {
            return Pair.of(null, new NoSuchCommandException(commandContext.getSender(), new ArrayList(), this.stringOrEmpty(args.peek())));
        }
        Pair<@Nullable Command<C>, @Nullable Exception> pair = this.parseCommand(new ArrayList(), commandContext, args, this.internalTree);
        if (pair.getFirst() != null && (command = pair.getFirst()).getSenderType().isPresent() && !command.getSenderType().get().isAssignableFrom(commandContext.getSender().getClass())) {
            return Pair.of(null, new InvalidCommandSenderException(commandContext.getSender(), command.getSenderType().get(), new ArrayList(command.getArguments()), command));
        }
        return pair;
    }

    private @NonNull Pair<@Nullable Command<C>, @Nullable Exception> parseCommand(@NonNull List<@NonNull CommandArgument<C, ?>> parsedArguments, @NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> commandQueue, @NonNull Node<@Nullable CommandArgument<C, ?>> root) {
        CommandPermission permission = this.isPermitted(commandContext.getSender(), root);
        if (permission != null) {
            return Pair.of(null, new NoPermissionException(permission, commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
        }
        Pair<@Nullable Command<C>, @Nullable Exception> parsedChild = this.attemptParseUnambiguousChild(parsedArguments, commandContext, root, commandQueue);
        if (parsedChild.getFirst() != null || parsedChild.getSecond() != null) {
            return parsedChild;
        }
        if (((Node)root).children.isEmpty()) {
            if (root.getValue() != null && root.getValue().getOwningCommand() != null) {
                if (commandQueue.isEmpty()) {
                    return Pair.of(this.cast(root.getValue().getOwningCommand()), null);
                }
                return Pair.of(null, new InvalidSyntaxException(this.commandManager.commandSyntaxFormatter().apply(parsedArguments, root), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
            }
            return Pair.of(null, new InvalidSyntaxException(this.commandManager.commandSyntaxFormatter().apply(parsedArguments, root), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
        }
        Iterator<Node<CommandArgument<C, ?>>> childIterator = root.getChildren().iterator();
        if (childIterator.hasNext()) {
            while (childIterator.hasNext()) {
                Node<CommandArgument<C, ?>> child = childIterator.next();
                if (child.getValue() == null) continue;
                CommandArgument<C, ?> argument = child.getValue();
                CommandContext.ArgumentTiming argumentTiming = commandContext.createTiming(argument);
                argumentTiming.setStart(System.nanoTime());
                commandContext.setCurrentArgument(argument);
                ArgumentParseResult<?> result = argument.getParser().parse(commandContext, commandQueue);
                argumentTiming.setEnd(System.nanoTime(), result.getFailure().isPresent());
                if (!result.getParsedValue().isPresent()) continue;
                parsedArguments.add(child.getValue());
                return this.parseCommand(parsedArguments, commandContext, commandQueue, child);
            }
        }
        if (root.equals(this.internalTree)) {
            return Pair.of(null, new NoSuchCommandException(commandContext.getSender(), this.getChain(root).stream().map(Node::getValue).collect(Collectors.toList()), this.stringOrEmpty(commandQueue.peek())));
        }
        if (root.getValue() != null && root.getValue().getOwningCommand() != null && commandQueue.isEmpty()) {
            Command<C> command = root.getValue().getOwningCommand();
            if (!this.getCommandManager().hasPermission(commandContext.getSender(), command.getCommandPermission())) {
                return Pair.of(null, new NoPermissionException(command.getCommandPermission(), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
            }
            return Pair.of(root.getValue().getOwningCommand(), null);
        }
        return Pair.of(null, new InvalidSyntaxException(this.commandManager.commandSyntaxFormatter().apply(parsedArguments, root), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
    }

    private @NonNull Pair<@Nullable Command<C>, @Nullable Exception> attemptParseUnambiguousChild(@NonNull List<@NonNull CommandArgument<C, ?>> parsedArguments, @NonNull CommandContext<C> commandContext, @NonNull Node<@Nullable CommandArgument<C, ?>> root, @NonNull Queue<String> commandQueue) {
        List argumentNodes;
        List<Node<CommandArgument<C, ?>>> children = root.getChildren();
        if (!commandQueue.isEmpty()) {
            String literal = commandQueue.peek();
            boolean matchesLiteral = children.stream().filter(n -> n.getValue() instanceof StaticArgument).map(n -> (StaticArgument)n.getValue()).flatMap(arg -> Stream.concat(Stream.of(arg.getName()), arg.getAliases().stream())).anyMatch(arg -> arg.equals(literal));
            if (matchesLiteral) {
                return Pair.of(null, null);
            }
        }
        if ((argumentNodes = children.stream().filter(n -> n.getValue() != null && !(n.getValue() instanceof StaticArgument)).collect(Collectors.toList())).size() > 1) {
            throw new IllegalStateException("Unexpected ambiguity detected, number of dynamic child nodes should not exceed 1");
        }
        if (!argumentNodes.isEmpty()) {
            Node child = (Node)argumentNodes.get(0);
            CommandPermission permission = this.isPermitted(commandContext.getSender(), child);
            if (!commandQueue.isEmpty() && permission != null) {
                return Pair.of(null, new NoPermissionException(permission, commandContext.getSender(), this.getChain(child).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
            }
            if (child.getValue() != null) {
                ArgumentParseResult<Boolean> result;
                if (commandQueue.isEmpty() && !(child.getValue() instanceof FlagArgument)) {
                    if (((CommandArgument)child.getValue()).hasDefaultValue()) {
                        commandQueue.add(((CommandArgument)child.getValue()).getDefaultValue());
                    } else {
                        if (!((CommandArgument)child.getValue()).isRequired()) {
                            if (((CommandArgument)child.getValue()).getOwningCommand() == null) {
                                Node node2 = child;
                                while (!node2.isLeaf()) {
                                    if ((node2 = node2.getChildren().get(0)).getValue() == null || ((CommandArgument)node2.getValue()).getOwningCommand() == null) continue;
                                    child.getValue().setOwningCommand(node2.getValue().getOwningCommand());
                                }
                            }
                            return Pair.of(((CommandArgument)child.getValue()).getOwningCommand(), null);
                        }
                        if (child.isLeaf()) {
                            if (root.getValue() != null && root.getValue().getOwningCommand() != null) {
                                Command<C> command = root.getValue().getOwningCommand();
                                if (!this.getCommandManager().hasPermission(commandContext.getSender(), command.getCommandPermission())) {
                                    return Pair.of(null, new NoPermissionException(command.getCommandPermission(), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
                                }
                                return Pair.of(command, null);
                            }
                            return Pair.of(null, new InvalidSyntaxException(this.commandManager.commandSyntaxFormatter().apply(Objects.requireNonNull(((CommandArgument)child.getValue()).getOwningCommand()).getArguments(), child), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
                        }
                        if (root.getValue() != null && root.getValue().getOwningCommand() != null) {
                            Command<C> command = root.getValue().getOwningCommand();
                            if (!this.getCommandManager().hasPermission(commandContext.getSender(), command.getCommandPermission())) {
                                return Pair.of(null, new NoPermissionException(command.getCommandPermission(), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
                            }
                            return Pair.of(command, null);
                        }
                        return Pair.of(null, new InvalidSyntaxException(this.commandManager.commandSyntaxFormatter().apply(parsedArguments, root), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
                    }
                }
                CommandArgument argument = (CommandArgument)child.getValue();
                CommandContext.ArgumentTiming argumentTiming = commandContext.createTiming(argument);
                argumentTiming.setStart(System.nanoTime());
                ArgumentParseResult<Boolean> preParseResult = ((CommandArgument)child.getValue()).preprocess(commandContext, commandQueue);
                if (!preParseResult.getFailure().isPresent() && preParseResult.getParsedValue().orElse(false).booleanValue()) {
                    commandContext.setCurrentArgument(argument);
                    result = argument.getParser().parse(commandContext, commandQueue);
                } else {
                    result = preParseResult;
                }
                argumentTiming.setEnd(System.nanoTime(), result.getFailure().isPresent());
                if (result.getParsedValue().isPresent()) {
                    commandContext.store(child.getValue().getName(), result.getParsedValue().get());
                    if (child.isLeaf()) {
                        if (commandQueue.isEmpty()) {
                            return Pair.of(this.cast(child.getValue().getOwningCommand()), null);
                        }
                        return Pair.of(null, new InvalidSyntaxException(this.commandManager.commandSyntaxFormatter().apply(parsedArguments, child), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
                    }
                    parsedArguments.add(child.getValue());
                    return this.parseCommand(parsedArguments, commandContext, commandQueue, child);
                }
                if (result.getFailure().isPresent()) {
                    return Pair.of(null, new ArgumentParseException(result.getFailure().get(), commandContext.getSender(), this.getChain(child).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
                }
            }
        }
        return Pair.of(null, null);
    }

    public @NonNull List<@NonNull String> getSuggestions(@NonNull CommandContext<C> context, @NonNull Queue<@NonNull String> commandQueue) {
        return this.getSuggestions(context, commandQueue, this.internalTree);
    }

    private @NonNull List<@NonNull String> getSuggestions(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> commandQueue, @NonNull Node<@Nullable CommandArgument<C, ?>> root) {
        if (this.isPermitted(commandContext.getSender(), root) != null) {
            return Collections.emptyList();
        }
        List<Node<CommandArgument<C, ?>>> children = root.getChildren();
        List staticArguments = children.stream().filter(n -> n.getValue() instanceof StaticArgument).collect(Collectors.toList());
        if (!staticArguments.isEmpty() && !commandQueue.isEmpty()) {
            LinkedList<String> commandQueueCopy = new LinkedList<String>(commandQueue);
            Iterator childIterator = staticArguments.iterator();
            if (childIterator.hasNext()) {
                while (childIterator.hasNext()) {
                    Node<CommandArgument<C, ?>> child = (Node)childIterator.next();
                    if (child.getValue() == null) continue;
                    commandContext.setCurrentArgument((CommandArgument)child.getValue());
                    ArgumentParseResult result = ((CommandArgument)child.getValue()).getParser().parse(commandContext, commandQueue);
                    if (!result.getParsedValue().isPresent()) continue;
                    if (commandQueue.isEmpty()) break;
                    return this.getSuggestions(commandContext, commandQueue, child);
                }
            }
            commandQueue.clear();
            commandQueue.addAll(commandQueueCopy);
        }
        LinkedList<String> suggestions = new LinkedList<String>();
        if (commandQueue.size() <= 1) {
            String literalValue = this.stringOrEmpty(commandQueue.peek());
            for (Node argument : staticArguments) {
                if (this.isPermitted(commandContext.getSender(), argument) != null) continue;
                commandContext.setCurrentArgument((CommandArgument)argument.getValue());
                List<String> suggestionsToAdd = ((CommandArgument)argument.getValue()).getSuggestionsProvider().apply(commandContext, literalValue);
                for (String suggestion : suggestionsToAdd) {
                    if (suggestion.equals(literalValue) || !suggestion.startsWith(literalValue)) continue;
                    suggestions.add(suggestion);
                }
            }
        }
        for (Node<CommandArgument<C, ?>> child : root.getChildren()) {
            if (child.getValue() == null || child.getValue() instanceof StaticArgument) continue;
            suggestions.addAll(this.suggestionsForDynamicArgument(commandContext, commandQueue, child));
        }
        return suggestions;
    }

    private @NonNull List<@NonNull String> suggestionsForDynamicArgument(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> commandQueue, @NonNull Node<@Nullable CommandArgument<C, ?>> child) {
        boolean preParseSuccess;
        if (child.getValue() == null) {
            return Collections.emptyList();
        }
        if (child.getValue() instanceof CompoundArgument) {
            CompoundArgument compoundArgument = (CompoundArgument)child.getValue();
            int requiredArguments = compoundArgument.getParserTuple().getSize();
            if (commandQueue.size() <= requiredArguments) {
                for (int i = 0; i < requiredArguments - 1 && commandQueue.size() > 1; ++i) {
                    commandQueue.remove();
                    commandContext.store(PARSING_ARGUMENT_KEY, Integer.valueOf(i + 2));
                }
            }
        } else if (child.getValue().getParser() instanceof FlagArgument.FlagArgumentParser) {
            FlagArgument.FlagArgumentParser parser = (FlagArgument.FlagArgumentParser)child.getValue().getParser();
            Optional<String> lastFlag = parser.parseCurrentFlag(commandContext, commandQueue);
            lastFlag.ifPresent(s -> commandContext.store(FlagArgument.FLAG_META_KEY, s));
            if (!lastFlag.isPresent()) {
                commandContext.remove(FlagArgument.FLAG_META_KEY);
            }
        } else if (GenericTypeReflector.erase((Type)child.getValue().getValueType().getType()).isArray()) {
            while (commandQueue.size() > 1) {
                commandQueue.remove();
            }
        } else if (commandQueue.size() <= child.getValue().getParser().getRequestedArgumentCount()) {
            for (int i = 0; i < child.getValue().getParser().getRequestedArgumentCount() - 1 && commandQueue.size() > 1; ++i) {
                commandContext.store(String.format("%s_%d", child.getValue().getName(), i), commandQueue.remove());
            }
        }
        if (commandQueue.isEmpty()) {
            return Collections.emptyList();
        }
        if (child.isLeaf()) {
            if (commandQueue.size() == 1) {
                return this.directSuggestions(commandContext, child, commandQueue.peek());
            }
            if (child.getValue() instanceof CompoundArgument) {
                return this.directSuggestions(commandContext, child, (String)((LinkedList)commandQueue).getLast());
            }
        } else if (commandQueue.size() == 1 && commandQueue.peek().isEmpty()) {
            return this.directSuggestions(commandContext, child, commandQueue.peek());
        }
        LinkedList<String> commandQueueOriginal = new LinkedList<String>(commandQueue);
        ArgumentParseResult<Boolean> preParseResult = child.getValue().preprocess(commandContext, commandQueue);
        boolean bl = preParseSuccess = !preParseResult.getFailure().isPresent() && preParseResult.getParsedValue().orElse(false) != false;
        if (preParseSuccess) {
            commandContext.setCurrentArgument(child.getValue());
            ArgumentParseResult<?> result = child.getValue().getParser().parse(commandContext, commandQueue);
            Optional<?> parsedValue = result.getParsedValue();
            boolean parseSuccess = parsedValue.isPresent();
            if (child.isLeaf()) {
                if (commandQueue.isEmpty()) {
                    commandQueue.addAll(commandQueueOriginal);
                    return this.directSuggestions(commandContext, child, String.join((CharSequence)" ", commandQueue));
                }
                return Collections.emptyList();
            }
            if (parseSuccess && !commandQueue.isEmpty()) {
                commandContext.store(child.getValue().getName(), parsedValue.get());
                return this.getSuggestions(commandContext, commandQueue, child);
            }
            if (!parseSuccess && commandQueueOriginal.size() > 1) {
                commandQueue.clear();
                commandQueue.addAll(commandQueueOriginal);
                return Collections.emptyList();
            }
        }
        commandQueue.clear();
        commandQueue.addAll(commandQueueOriginal);
        if (!preParseSuccess && commandQueue.size() > 1) {
            return Collections.emptyList();
        }
        return this.directSuggestions(commandContext, child, commandQueue.peek());
    }

    private @NonNull String stringOrEmpty(@Nullable String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private @NonNull List<@NonNull String> directSuggestions(@NonNull CommandContext<C> commandContext, @NonNull Node<@NonNull CommandArgument<C, ?>> current, @NonNull String text) {
        CommandArgument<C, ?> argument = Objects.requireNonNull(current.getValue());
        commandContext.setCurrentArgument(argument);
        List<String> suggestions = argument.getSuggestionsProvider().apply(commandContext, text);
        if (argument instanceof FlagArgument && !current.getChildren().isEmpty() && !text.startsWith("-") && !commandContext.getOptional(FlagArgument.FLAG_META_KEY).isPresent()) {
            suggestions = new ArrayList<String>(suggestions);
            for (Node<CommandArgument<C, ?>> child : current.getChildren()) {
                argument = Objects.requireNonNull(child.getValue());
                commandContext.setCurrentArgument(argument);
                suggestions.addAll((Collection<String>)argument.getSuggestionsProvider().apply(commandContext, text));
            }
        }
        return suggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCommand(@NonNull Command<C> command) {
        Object object = this.commandLock;
        synchronized (object) {
            Node node = this.internalTree;
            FlagArgument<C> flags = command.flagArgument();
            List<CommandArgument<C, ?>> nonFlagArguments = command.nonFlagArguments();
            int flagStartIdx = this.flagStartIndex(nonFlagArguments, flags);
            for (int i = 0; i < nonFlagArguments.size(); ++i) {
                CommandArgument<C, ?> argument = nonFlagArguments.get(i);
                Node tempNode = node.getChild(argument);
                if (tempNode == null) {
                    tempNode = node.addChild(argument);
                } else if (argument instanceof StaticArgument && tempNode.getValue() != null) {
                    for (String alias : ((StaticArgument)argument).getAliases()) {
                        ((StaticArgument)tempNode.getValue()).registerAlias(alias);
                    }
                }
                if (node.children.size() > 0) {
                    node.children.sort(Comparator.comparing(Node::getValue));
                }
                tempNode.setParent(node);
                node = tempNode;
                if (i < flagStartIdx) continue;
                tempNode = node.addChild(flags);
                tempNode.setParent(node);
                node = tempNode;
            }
            if (node.getValue() != null) {
                if (node.getValue().getOwningCommand() != null) {
                    throw new IllegalStateException(String.format("Duplicate command chains detected. Node '%s' already has an owning command (%s)", node.toString(), node.getValue().getOwningCommand().toString()));
                }
                node.getValue().setOwningCommand(command);
            }
            this.verifyAndRegister();
        }
    }

    private int flagStartIndex(@NonNull List<CommandArgument<C, ?>> arguments, @Nullable FlagArgument<C> flags) {
        if (flags == null) {
            return Integer.MAX_VALUE;
        }
        if (this.commandManager.getSetting(CommandManager.ManagerSettings.LIBERAL_FLAG_PARSING)) {
            for (int i = arguments.size() - 1; i >= 0; --i) {
                if (!(arguments.get(i) instanceof StaticArgument)) continue;
                return i;
            }
        }
        return arguments.size() - 1;
    }

    private @Nullable CommandPermission isPermitted(@NonNull C sender, @NonNull Node<@Nullable CommandArgument<C, ?>> node) {
        CommandPermission permission = (CommandPermission)((Node)node).nodeMeta.get("permission");
        if (permission != null) {
            return this.commandManager.hasPermission(sender, permission) ? null : permission;
        }
        if (node.isLeaf()) {
            return this.commandManager.hasPermission(sender, Objects.requireNonNull(Objects.requireNonNull((CommandArgument)((Node)node).value, "node.value").getOwningCommand(), "owning command").getCommandPermission()) ? null : Objects.requireNonNull(((CommandArgument)((Node)node).value).getOwningCommand(), "owning command").getCommandPermission();
        }
        LinkedList<CommandPermission> missingPermissions = new LinkedList<CommandPermission>();
        for (Node<CommandArgument<C, ?>> child : node.getChildren()) {
            CommandPermission check = this.isPermitted(sender, child);
            if (check == null) {
                return null;
            }
            missingPermissions.add(check);
        }
        return OrPermission.of(missingPermissions);
    }

    public void verifyAndRegister() {
        ((Node)this.internalTree).children.stream().map(Node::getValue).forEach(commandArgument -> {
            if (!(commandArgument instanceof StaticArgument)) {
                throw new IllegalStateException("Top level command argument cannot be a variable");
            }
        });
        this.checkAmbiguity(this.internalTree);
        this.getLeaves(this.internalTree).forEach(leaf -> {
            if (leaf.getOwningCommand() == null) {
                throw new NoCommandInLeafException((CommandArgument<?, ?>)leaf);
            }
            Command owningCommand = leaf.getOwningCommand();
            this.commandManager.commandRegistrationHandler().registerCommand(owningCommand);
        });
        this.getLeavesRaw(this.internalTree).forEach(node -> {
            CommandPermission commandPermission = ((CommandArgument)node.getValue()).getOwningCommand().getCommandPermission();
            ((Node)node).nodeMeta.put("permission", commandPermission);
            List<Node<CommandArgument<C, ?>>> chain = this.getChain((Node<CommandArgument<C, ?>>)node);
            Collections.reverse(chain);
            chain = chain.subList(1, chain.size());
            for (Node<CommandArgument<C, ?>> commandArgumentNode : chain) {
                CommandPermission existingPermission = (CommandPermission)((Node)commandArgumentNode).nodeMeta.get("permission");
                CommandPermission permission = existingPermission != null ? OrPermission.of(Arrays.asList(commandPermission, existingPermission)) : commandPermission;
                if (commandArgumentNode.getValue() != null && commandArgumentNode.getValue().getOwningCommand() != null) {
                    Command<C> command = commandArgumentNode.getValue().getOwningCommand();
                    permission = this.getCommandManager().getSetting(CommandManager.ManagerSettings.ENFORCE_INTERMEDIARY_PERMISSIONS) ? command.getCommandPermission() : OrPermission.of(Arrays.asList(permission, command.getCommandPermission()));
                }
                ((Node)commandArgumentNode).nodeMeta.put("permission", permission);
            }
        });
    }

    private void checkAmbiguity(@NonNull Node<@Nullable CommandArgument<C, ?>> node) throws AmbiguousNodeException {
        if (node.isLeaf()) {
            return;
        }
        List childVariableArguments = ((Node)node).children.stream().filter(n -> n.getValue() != null && !(n.getValue() instanceof StaticArgument)).collect(Collectors.toList());
        if (childVariableArguments.size() > 1) {
            Node child = (Node)childVariableArguments.get(0);
            throw new AmbiguousNodeException(node.getValue(), (CommandArgument)child.getValue(), node.getChildren().stream().filter(n -> n.getValue() != null).map(Node::getValue).collect(Collectors.toList()));
        }
        List childStaticArguments = ((Node)node).children.stream().filter(n -> n.getValue() instanceof StaticArgument).map(n -> n).collect(Collectors.toList());
        HashSet<String> checkedLiterals = new HashSet<String>();
        for (Node child : childStaticArguments) {
            for (String nameOrAlias : ((StaticArgument)child.getValue()).getAliases()) {
                if (checkedLiterals.add(nameOrAlias)) continue;
                throw new AmbiguousNodeException(node.getValue(), (CommandArgument)child.getValue(), node.getChildren().stream().filter(n -> n.getValue() != null).map(Node::getValue).collect(Collectors.toList()));
            }
        }
        ((Node)node).children.forEach(this::checkAmbiguity);
    }

    private @NonNull List<@NonNull Node<@Nullable CommandArgument<C, ?>>> getLeavesRaw(@NonNull Node<@Nullable CommandArgument<C, ?>> node) {
        LinkedList leaves = new LinkedList();
        if (node.isLeaf()) {
            if (node.getValue() != null) {
                leaves.add(node);
            }
        } else {
            ((Node)node).children.forEach(child -> leaves.addAll(this.getLeavesRaw((Node<CommandArgument<C, ?>>)child)));
        }
        return leaves;
    }

    private @NonNull List<@NonNull CommandArgument<C, ?>> getLeaves(@NonNull Node<@NonNull CommandArgument<C, ?>> node) {
        LinkedList leaves = new LinkedList();
        if (node.isLeaf()) {
            if (node.getValue() != null) {
                leaves.add(node.getValue());
            }
        } else {
            ((Node)node).children.forEach(child -> leaves.addAll(this.getLeaves((Node<CommandArgument<C, ?>>)child)));
        }
        return leaves;
    }

    private @NonNull List<@NonNull Node<@Nullable CommandArgument<C, ?>>> getChain(@Nullable Node<@Nullable CommandArgument<C, ?>> end) {
        LinkedList chain = new LinkedList();
        for (Node<CommandArgument<C, ?>> tail = end; tail != null; tail = tail.getParent()) {
            chain.add(tail);
        }
        Collections.reverse(chain);
        return chain;
    }

    private @Nullable Command<C> cast(@Nullable Command<C> command) {
        return command;
    }

    public @NonNull Collection<@NonNull Node<@Nullable CommandArgument<C, ?>>> getRootNodes() {
        return this.internalTree.getChildren();
    }

    public @Nullable Node<@Nullable CommandArgument<C, ?>> getNamedNode(@Nullable String name) {
        for (Node<CommandArgument<C, ?>> node : this.getRootNodes()) {
            if (node.getValue() == null || !(node.getValue() instanceof StaticArgument)) continue;
            StaticArgument staticArgument = (StaticArgument)node.getValue();
            for (String alias : staticArgument.getAliases()) {
                if (!alias.equalsIgnoreCase(name)) continue;
                return node;
            }
        }
        return null;
    }

    void deleteRecursively(@NonNull Node<@Nullable CommandArgument<C, ?>> node, boolean root, Consumer<Command<C>> op) {
        Command<C> owner;
        for (Node child : new ArrayList(((Node)node).children)) {
            this.deleteRecursively(child, false, op);
        }
        @Nullable CommandArgument<C, ?> value = node.getValue();
        Command<C> command = owner = value == null ? null : value.getOwningCommand();
        if (owner != null) {
            op.accept(owner);
        }
        this.removeNode(node, root);
    }

    private boolean removeNode(@NonNull Node<@Nullable CommandArgument<C, ?>> node, boolean root) {
        if (root) {
            return ((Node)this.internalTree).removeChild((Node)node);
        }
        return ((Node)node.getParent()).removeChild((Node)node);
    }

    public @NonNull CommandManager<C> getCommandManager() {
        return this.commandManager;
    }

    public static final class Node<T> {
        private final Map<String, Object> nodeMeta = new HashMap<String, Object>();
        private final List<Node<T>> children = new LinkedList<Node<T>>();
        private T value;
        private Node<T> parent;

        private Node(@Nullable T value) {
            this.value = value;
        }

        public @NonNull List<@NonNull Node<@Nullable T>> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        private @NonNull Node<@Nullable T> addChild(@NonNull T child) {
            Node<T> node = new Node<T>(child);
            this.children.add(node);
            return node;
        }

        private @Nullable Node<@Nullable T> getChild(@NonNull T type) {
            for (Node<T> child : this.children) {
                if (!type.equals(child.getValue())) continue;
                return child;
            }
            return null;
        }

        private boolean removeChild(@NonNull Node<T> child) {
            return this.children.remove(child);
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public @NonNull Map<@NonNull String, @NonNull Object> getNodeMeta() {
            return this.nodeMeta;
        }

        public @Nullable T getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.getValue(), node.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getValue());
        }

        public @Nullable Node<@Nullable T> getParent() {
            return this.parent;
        }

        public void setParent(@Nullable Node<@Nullable T> parent) {
            this.parent = parent;
        }

        public String toString() {
            return "Node{value=" + this.value + '}';
        }
    }
}

