/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.arguments.standard;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.captions.StandardCaptionKeys;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.ParserException;
import cloud.commandframework.util.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.returnsreceiver.qual.This;

@API(status=API.Status.STABLE)
public final class StringArgument<C>
extends CommandArgument<C, String> {
    private static final Pattern QUOTED_DOUBLE = Pattern.compile("\"(?<inner>(?:[^\"\\\\]|\\\\.)*)\"");
    private static final Pattern QUOTED_SINGLE = Pattern.compile("'(?<inner>(?:[^'\\\\]|\\\\.)*)'");
    private final StringMode stringMode;

    private StringArgument(boolean required, @NonNull String name, @NonNull StringMode stringMode, @NonNull String defaultValue, @NonNull BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new StringParser<C>(stringMode, suggestionsProvider), defaultValue, String.class, suggestionsProvider, defaultDescription);
        this.stringMode = stringMode;
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, String> of(@NonNull String name) {
        return StringArgument.newBuilder(name).single().asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, String> of(@NonNull String name, @NonNull StringMode stringMode) {
        return ((Builder)StringArgument.newBuilder(name)).withMode(stringMode).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, String> optional(@NonNull String name) {
        return StringArgument.newBuilder(name).single().asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, String> optional(@NonNull String name, @NonNull StringMode stringMode) {
        return ((Builder)StringArgument.newBuilder(name)).withMode(stringMode).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, String> optional(@NonNull String name, @NonNull String defaultString) {
        return StringArgument.newBuilder(name).asOptionalWithDefault(defaultString).build();
    }

    public static <C> @NonNull CommandArgument<C, String> single(@NonNull String name) {
        return StringArgument.of(name, StringMode.SINGLE);
    }

    public static <C> @NonNull CommandArgument<C, String> greedy(@NonNull String name) {
        return StringArgument.of(name, StringMode.GREEDY);
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public static <C> @NonNull CommandArgument<C, String> greedyFlagYielding(@NonNull String name) {
        return StringArgument.of(name, StringMode.GREEDY_FLAG_YIELDING);
    }

    public static <C> @NonNull CommandArgument<C, String> quoted(@NonNull String name) {
        return StringArgument.of(name, StringMode.QUOTED);
    }

    public @NonNull StringMode getStringMode() {
        return this.stringMode;
    }

    @API(status=API.Status.STABLE)
    public static enum StringMode {
        SINGLE,
        QUOTED,
        GREEDY,
        GREEDY_FLAG_YIELDING;

    }

    @API(status=API.Status.STABLE)
    public static final class StringParser<C>
    implements ArgumentParser<C, String> {
        private static final Pattern FLAG_PATTERN = Pattern.compile("(-[A-Za-z_\\-0-9])|(--[A-Za-z_\\-0-9]*)");
        private final StringMode stringMode;
        private final BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider;

        public StringParser(@NonNull StringMode stringMode, @NonNull BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider) {
            this.stringMode = stringMode;
            this.suggestionsProvider = suggestionsProvider;
        }

        @Override
        public @NonNull ArgumentParseResult<String> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(StringParser.class, commandContext));
            }
            if (this.stringMode == StringMode.SINGLE) {
                inputQueue.remove();
                return ArgumentParseResult.success(input);
            }
            if (this.stringMode == StringMode.QUOTED) {
                return this.parseQuoted(commandContext, inputQueue);
            }
            return this.parseGreedy(commandContext, inputQueue);
        }

        private @NonNull ArgumentParseResult<String> parseQuoted(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String peek = inputQueue.peek();
            if (peek != null && !peek.startsWith("'") && !peek.startsWith("\"")) {
                inputQueue.remove();
                return ArgumentParseResult.success(peek);
            }
            StringJoiner sj = new StringJoiner(" ");
            for (String string : inputQueue) {
                sj.add(string);
            }
            String string = sj.toString();
            Matcher doubleMatcher = QUOTED_DOUBLE.matcher(string);
            String doubleMatch = null;
            if (doubleMatcher.find()) {
                doubleMatch = doubleMatcher.group("inner");
            }
            Matcher singleMatcher = QUOTED_SINGLE.matcher(string);
            String singleMatch = null;
            if (singleMatcher.find()) {
                singleMatch = singleMatcher.group("inner");
            }
            String inner = null;
            if (singleMatch != null && doubleMatch != null) {
                int singleIndex = string.indexOf(singleMatch);
                int doubleIndex = string.indexOf(doubleMatch);
                inner = doubleIndex < singleIndex ? doubleMatch : singleMatch;
            } else if (singleMatch == null && doubleMatch != null) {
                inner = doubleMatch;
            } else if (singleMatch != null) {
                inner = singleMatch;
            }
            if (inner != null) {
                int numSpaces = StringUtils.countCharOccurrences(inner, ' ');
                for (int i = 0; i <= numSpaces; ++i) {
                    inputQueue.remove();
                }
            } else {
                inner = inputQueue.peek();
                if (inner.startsWith("\"") || inner.startsWith("'")) {
                    return ArgumentParseResult.failure(new StringParseException(sj.toString(), StringMode.QUOTED, commandContext));
                }
                inputQueue.remove();
            }
            inner = inner.replace("\\\"", "\"").replace("\\'", "'");
            return ArgumentParseResult.success(inner);
        }

        private @NonNull ArgumentParseResult<String> parseGreedy(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String string;
            StringJoiner sj = new StringJoiner(" ");
            int size = inputQueue.size();
            for (int i = 0; !(i >= size || (string = inputQueue.peek()) == null || this.stringMode == StringMode.GREEDY_FLAG_YIELDING && FLAG_PATTERN.matcher(string).matches()); ++i) {
                sj.add(string);
                inputQueue.remove();
            }
            return ArgumentParseResult.success(sj.toString());
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return this.suggestionsProvider.apply(commandContext, input);
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        public @NonNull StringMode getStringMode() {
            return this.stringMode;
        }
    }

    @API(status=API.Status.STABLE)
    public static final class Builder<C>
    extends CommandArgument.Builder<C, String> {
        private StringMode stringMode = StringMode.SINGLE;
        private BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider = (v1, v2) -> Collections.emptyList();

        private Builder(@NonNull String name) {
            super(String.class, name);
        }

        private @NonNull @This Builder<C> withMode(@NonNull StringMode stringMode) {
            this.stringMode = stringMode;
            return this;
        }

        public @NonNull @This Builder<C> greedy() {
            this.stringMode = StringMode.GREEDY;
            return this;
        }

        @API(status=API.Status.STABLE, since="1.7.0")
        public @NonNull @This Builder<C> greedyFlagYielding() {
            this.stringMode = StringMode.GREEDY_FLAG_YIELDING;
            return this;
        }

        public @NonNull @This Builder<C> single() {
            this.stringMode = StringMode.SINGLE;
            return this;
        }

        public @NonNull @This Builder<C> quoted() {
            this.stringMode = StringMode.QUOTED;
            return this;
        }

        public @NonNull @This Builder<C> withSuggestionsProvider(@NonNull BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider) {
            this.suggestionsProvider = suggestionsProvider;
            return this;
        }

        public @NonNull StringArgument<C> build() {
            return new StringArgument(this.isRequired(), this.getName(), this.stringMode, this.getDefaultValue(), this.suggestionsProvider, this.getDefaultDescription());
        }
    }

    @API(status=API.Status.STABLE)
    public static final class StringParseException
    extends ParserException {
        private static final long serialVersionUID = -8903115465005472945L;
        private final String input;
        private final StringMode stringMode;

        public StringParseException(@NonNull String input, @NonNull StringMode stringMode, @NonNull CommandContext<?> context) {
            super(StringParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_STRING, CaptionVariable.of("input", input), CaptionVariable.of("stringMode", stringMode.name()));
            this.input = input;
            this.stringMode = stringMode;
        }

        public @NonNull String getInput() {
            return this.input;
        }

        public @NonNull StringMode getStringMode() {
            return this.stringMode;
        }
    }
}

