/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.arguments.standard;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.captions.StandardCaptionKeys;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.ParserException;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BooleanArgument<C>
extends CommandArgument<C, Boolean> {
    private final boolean liberal;

    private BooleanArgument(boolean required, @NonNull String name, boolean liberal, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription description) {
        super(required, name, new BooleanParser(liberal), defaultValue, Boolean.class, suggestionsProvider, description);
        this.liberal = liberal;
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Boolean> of(@NonNull String name) {
        return BooleanArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Boolean> optional(@NonNull String name) {
        return BooleanArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Boolean> optional(@NonNull String name, boolean defaultBoolean) {
        return BooleanArgument.newBuilder(name).asOptionalWithDefault(Boolean.toString(defaultBoolean)).build();
    }

    public boolean isLiberal() {
        return this.liberal;
    }

    public static final class BooleanParser<C>
    implements ArgumentParser<C, Boolean> {
        private static final List<String> LIBERAL = Arrays.asList("TRUE", "YES", "ON", "FALSE", "NO", "OFF");
        private static final List<String> LIBERAL_TRUE = Arrays.asList("TRUE", "YES", "ON");
        private static final List<String> LIBERAL_FALSE = Arrays.asList("FALSE", "NO", "OFF");
        private final boolean liberal;

        public BooleanParser(boolean liberal) {
            this.liberal = liberal;
        }

        @Override
        public @NonNull ArgumentParseResult<Boolean> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(BooleanParser.class, commandContext));
            }
            inputQueue.remove();
            if (!this.liberal) {
                if (input.equalsIgnoreCase("true")) {
                    return ArgumentParseResult.success(true);
                }
                if (input.equalsIgnoreCase("false")) {
                    return ArgumentParseResult.success(false);
                }
                return ArgumentParseResult.failure(new BooleanParseException(input, false, commandContext));
            }
            String uppercaseInput = input.toUpperCase();
            if (LIBERAL_TRUE.contains(uppercaseInput)) {
                return ArgumentParseResult.success(true);
            }
            if (LIBERAL_FALSE.contains(uppercaseInput)) {
                return ArgumentParseResult.success(false);
            }
            return ArgumentParseResult.failure(new BooleanParseException(input, true, commandContext));
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            if (!this.liberal) {
                return Arrays.asList("TRUE", "FALSE");
            }
            return LIBERAL;
        }

        @Override
        public boolean isContextFree() {
            return true;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Boolean> {
        private boolean liberal = false;

        private Builder(@NonNull String name) {
            super(Boolean.class, name);
        }

        public @NonNull Builder<C> withLiberal(boolean liberal) {
            this.liberal = liberal;
            return this;
        }

        public @NonNull BooleanArgument<C> build() {
            return new BooleanArgument(this.isRequired(), this.getName(), this.liberal, this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    public static final class BooleanParseException
    extends ParserException {
        private static final long serialVersionUID = -2688852086944850025L;
        private final String input;
        private final boolean liberal;

        public BooleanParseException(@NonNull String input, boolean liberal, @NonNull CommandContext<?> context) {
            super(BooleanParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_BOOLEAN, CaptionVariable.of("input", input));
            this.input = input;
            this.liberal = liberal;
        }

        public String getInput() {
            return this.input;
        }

        public boolean isLiberal() {
            return this.liberal;
        }
    }
}

