/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.meta;

import cloud.commandframework.meta.CommandMeta;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SimpleCommandMeta
extends CommandMeta {
    private final Map<String, Object> metaMap;

    @Deprecated
    protected SimpleCommandMeta(@NonNull Map<@NonNull String, @NonNull String> metaMap) {
        this.metaMap = Collections.unmodifiableMap(metaMap);
    }

    protected SimpleCommandMeta(SimpleCommandMeta source) {
        this.metaMap = source.metaMap;
    }

    SimpleCommandMeta(@NonNull Map<@NonNull String, @NonNull Object> metaMap, boolean unusedMarkerForNew) {
        this.metaMap = Collections.unmodifiableMap(metaMap);
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull SimpleCommandMeta empty() {
        return SimpleCommandMeta.builder().build();
    }

    @Override
    @Deprecated
    public final @NonNull Optional<String> getValue(@NonNull String key) {
        Object result = this.metaMap.get(key);
        if (result != null && !(result instanceof String)) {
            throw new IllegalArgumentException("Key '" + key + "' has been used for a new typed command meta and contains a non-string value!");
        }
        return Optional.ofNullable((String)result);
    }

    @Override
    @Deprecated
    public final @NonNull String getOrDefault(@NonNull String key, @NonNull String defaultValue) {
        return this.getValue(key).orElse(defaultValue);
    }

    @Override
    public final <V> @NonNull Optional<V> get(@NonNull CommandMeta.Key<V> key) {
        Object value = this.metaMap.get(key.getName());
        if (value == null) {
            if (key.getFallbackDerivation() != null) {
                return Optional.ofNullable(key.getFallbackDerivation().apply(this));
            }
            return Optional.empty();
        }
        if (!GenericTypeReflector.isSuperType((Type)key.getValueType().getType(), value.getClass())) {
            throw new IllegalArgumentException("Conflicting argument types between key type of " + key.getValueType().getType() + " and value type of " + value.getClass());
        }
        return Optional.of(value);
    }

    @Override
    public final <V> @NonNull V getOrDefault(@NonNull CommandMeta.Key<V> key, @NonNull V defaultValue) {
        return this.get(key).orElse(defaultValue);
    }

    @Override
    @Deprecated
    public final @NonNull Map<@NonNull String, @NonNull String> getAll() {
        return this.metaMap.entrySet().stream().filter(ent -> ent.getValue() instanceof String).collect(Collectors.toMap(Map.Entry::getKey, ent -> ent.getValue().toString()));
    }

    @Override
    public final @NonNull Map<@NonNull String, @NonNull ?> getAllValues() {
        return new HashMap<String, Object>(this.metaMap);
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SimpleCommandMeta that = (SimpleCommandMeta)other;
        return Objects.equals(this.metaMap, that.metaMap);
    }

    public final int hashCode() {
        return Objects.hashCode(this.metaMap);
    }

    public static final class Builder {
        private final Map<String, Object> map = new HashMap<String, Object>();

        private Builder() {
        }

        public @NonNull Builder with(@NonNull CommandMeta commandMeta) {
            if (commandMeta instanceof SimpleCommandMeta) {
                this.map.putAll(((SimpleCommandMeta)commandMeta).metaMap);
            } else {
                this.map.putAll(commandMeta.getAllValues());
            }
            return this;
        }

        @Deprecated
        public @NonNull Builder with(@NonNull String key, @NonNull String value) {
            this.map.put(key, value);
            return this;
        }

        public <V> @NonNull Builder with(@NonNull CommandMeta.Key<V> key, @NonNull V value) {
            this.map.put(key.getName(), value);
            return this;
        }

        public @NonNull SimpleCommandMeta build() {
            return new SimpleCommandMeta(this.map, false);
        }
    }
}

