/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.arguments.standard;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.NumberParseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.TreeSet;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IntegerArgument<C>
extends CommandArgument<C, Integer> {
    private static final int MAX_SUGGESTIONS_INCREMENT = 10;
    private static final int NUMBER_SHIFT_MULTIPLIER = 10;
    private final int min;
    private final int max;

    private IntegerArgument(boolean required, @NonNull String name, int min, int max, String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new IntegerParser(min, max), defaultValue, Integer.class, suggestionsProvider, defaultDescription);
        this.min = min;
        this.max = max;
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Integer> of(@NonNull String name) {
        return IntegerArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Integer> optional(@NonNull String name) {
        return IntegerArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Integer> optional(@NonNull String name, int defaultNum) {
        return IntegerArgument.newBuilder(name).asOptionalWithDefault(Integer.toString(defaultNum)).build();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public static final class IntegerParseException
    extends NumberParseException {
        private static final long serialVersionUID = -6933923056628373853L;

        public IntegerParseException(@NonNull String input, int min, int max, @NonNull CommandContext<?> commandContext) {
            super(input, min, max, IntegerParser.class, commandContext);
        }

        @Override
        public boolean hasMin() {
            return this.getMin().intValue() != Integer.MIN_VALUE;
        }

        @Override
        public boolean hasMax() {
            return this.getMax().intValue() != Integer.MAX_VALUE;
        }

        @Override
        public @NonNull String getNumberType() {
            return "integer";
        }
    }

    public static final class IntegerParser<C>
    implements ArgumentParser<C, Integer> {
        private final int min;
        private final int max;

        public IntegerParser(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public static @NonNull List<@NonNull String> getSuggestions(long min, long max, @NonNull String input) {
            TreeSet<Long> numbers = new TreeSet<Long>();
            try {
                long inputNum = Long.parseLong(input.equals("-") ? "-0" : (input.isEmpty() ? "0" : input));
                long inputNumAbsolute = Math.abs(inputNum);
                numbers.add(inputNumAbsolute);
                for (int i = 0; i < 10 && inputNum * 10L + (long)i <= max; ++i) {
                    numbers.add(inputNumAbsolute * 10L + (long)i);
                }
                LinkedList<String> suggestions = new LinkedList<String>();
                Iterator iterator = numbers.iterator();
                while (iterator.hasNext()) {
                    long number = (Long)iterator.next();
                    if (input.startsWith("-")) {
                        number = -number;
                    }
                    if (number < min || number > max) continue;
                    suggestions.add(String.valueOf(number));
                }
                return suggestions;
            }
            catch (Exception ignored) {
                return Collections.emptyList();
            }
        }

        @Override
        public @NonNull ArgumentParseResult<Integer> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(IntegerParser.class, commandContext));
            }
            try {
                int value = Integer.parseInt(input);
                if (value < this.min || value > this.max) {
                    return ArgumentParseResult.failure(new IntegerParseException(input, this.min, this.max, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(value);
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(new IntegerParseException(input, this.min, this.max, commandContext));
            }
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return IntegerParser.getSuggestions(this.min, this.max, input);
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Integer> {
        private int min = Integer.MIN_VALUE;
        private int max = Integer.MAX_VALUE;

        private Builder(@NonNull String name) {
            super(Integer.class, name);
        }

        public @NonNull Builder<C> withMin(int min) {
            this.min = min;
            return this;
        }

        public @NonNull Builder<C> withMax(int max) {
            this.max = max;
            return this;
        }

        public @NonNull IntegerArgument<C> build() {
            return new IntegerArgument(this.isRequired(), this.getName(), this.min, this.max, this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

