/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.arguments.standard;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.NumberParseException;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DoubleArgument<C>
extends CommandArgument<C, Double> {
    private final double min;
    private final double max;

    private DoubleArgument(boolean required, @NonNull String name, double min, double max, String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new DoubleParser(min, max), defaultValue, Double.class, suggestionsProvider, defaultDescription);
        this.min = min;
        this.max = max;
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Double> of(@NonNull String name) {
        return DoubleArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Double> optional(@NonNull String name) {
        return DoubleArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Double> optional(@NonNull String name, double defaultNum) {
        return DoubleArgument.newBuilder(name).asOptionalWithDefault(Double.toString(defaultNum)).build();
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public static final class DoubleParseException
    extends NumberParseException {
        private static final long serialVersionUID = 1764554911581976586L;

        public DoubleParseException(@NonNull String input, double min, double max, @NonNull CommandContext<?> commandContext) {
            super(input, min, max, DoubleParser.class, commandContext);
        }

        @Override
        public boolean hasMin() {
            return this.getMin().doubleValue() != Double.MIN_VALUE;
        }

        @Override
        public boolean hasMax() {
            return this.getMax().doubleValue() != Double.MAX_VALUE;
        }

        @Override
        public @NonNull String getNumberType() {
            return "double";
        }
    }

    public static final class DoubleParser<C>
    implements ArgumentParser<C, Double> {
        private final double min;
        private final double max;

        public DoubleParser(double min, double max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public @NonNull ArgumentParseResult<Double> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(DoubleParser.class, commandContext));
            }
            try {
                double value = Double.parseDouble(input);
                if (value < this.min || value > this.max) {
                    return ArgumentParseResult.failure(new DoubleParseException(input, this.min, this.max, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(value);
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(new DoubleParseException(input, this.min, this.max, commandContext));
            }
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        public double getMax() {
            return this.max;
        }

        public double getMin() {
            return this.min;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Double> {
        private double min = Double.NEGATIVE_INFINITY;
        private double max = Double.POSITIVE_INFINITY;

        private Builder(@NonNull String name) {
            super(Double.class, name);
        }

        public @NonNull Builder<C> withMin(int min) {
            this.min = min;
            return this;
        }

        public @NonNull Builder<C> withMax(int max) {
            this.max = max;
            return this;
        }

        public @NonNull DoubleArgument<C> build() {
            return new DoubleArgument(this.isRequired(), this.getName(), this.min, this.max, this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

