/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.arguments.compound;

import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.types.tuples.Tuple;
import io.leangen.geantyref.TypeToken;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CompoundArgument<T extends Tuple, C, O>
extends CommandArgument<C, O> {
    private final Tuple types;
    private final Tuple names;
    private final Tuple parserTuple;

    public CompoundArgument(boolean required, @NonNull String name, @NonNull Tuple names, @NonNull Tuple parserTuple, @NonNull Tuple types, @NonNull BiFunction<@NonNull C, @NonNull T, @NonNull O> mapper, @NonNull Function<@NonNull Object[], @NonNull T> tupleFactory, @NonNull TypeToken<O> valueType) {
        super(required, name, new CompoundParser(parserTuple, mapper, tupleFactory), "", valueType, null);
        this.parserTuple = parserTuple;
        this.names = names;
        this.types = types;
    }

    public @NonNull Tuple getParserTuple() {
        return this.parserTuple;
    }

    public @NonNull Tuple getNames() {
        return this.names;
    }

    public @NonNull Tuple getTypes() {
        return this.types;
    }

    private static final class CompoundParser<T extends Tuple, C, O>
    implements ArgumentParser<C, O> {
        private final Object[] parsers;
        private final BiFunction<C, T, O> mapper;
        private final Function<Object[], T> tupleFactory;

        private CompoundParser(@NonNull Tuple parserTuple, @NonNull BiFunction<@NonNull C, @NonNull T, @NonNull O> mapper, @NonNull Function<@NonNull Object[], @NonNull T> tupleFactory) {
            this.parsers = parserTuple.toArray();
            this.mapper = mapper;
            this.tupleFactory = tupleFactory;
        }

        @Override
        public @NonNull ArgumentParseResult<O> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            Object[] output = new Object[this.parsers.length];
            for (int i = 0; i < this.parsers.length; ++i) {
                ArgumentParser parser = (ArgumentParser)this.parsers[i];
                ArgumentParseResult result = parser.parse(commandContext, inputQueue);
                if (result.getFailure().isPresent()) {
                    return ArgumentParseResult.failure(result.getFailure().get());
                }
                output[i] = result.getParsedValue().orElse(null);
            }
            try {
                return ArgumentParseResult.success(this.mapper.apply(commandContext.getSender(), (Tuple)this.tupleFactory.apply(output)));
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(e);
            }
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            int argument = commandContext.getOrDefault("__parsing_argument__", Integer.valueOf(1)) - 1;
            return ((ArgumentParser)this.parsers[argument]).suggestions(commandContext, input);
        }
    }
}

