/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.exceptions.parsing;

import cloud.commandframework.captions.Caption;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.context.CommandContext;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ParserException
extends IllegalArgumentException {
    private static final long serialVersionUID = -4409795575435072170L;
    private final Class<?> argumentParser;
    private final CommandContext<?> context;
    private final Caption errorCaption;
    private final CaptionVariable[] captionVariables;

    protected ParserException(@NonNull Class<?> argumentParser, @NonNull CommandContext<?> context, @NonNull Caption errorCaption, CaptionVariable ... captionVariables) {
        this.argumentParser = argumentParser;
        this.context = context;
        this.errorCaption = errorCaption;
        this.captionVariables = captionVariables;
    }

    @Override
    public final String getMessage() {
        return this.context.formatMessage(this.errorCaption, this.captionVariables);
    }

    public final @NonNull Class<?> getArgumentParserClass() {
        return this.argumentParser;
    }

    public final @NonNull CommandContext<?> getContext() {
        return this.context;
    }
}

