/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.exceptions;

import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.exceptions.CommandParseException;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class InvalidCommandSenderException
extends CommandParseException {
    private static final long serialVersionUID = 7372142477529875598L;
    private final Class<?> requiredSender;

    public InvalidCommandSenderException(@NonNull Object commandSender, @NonNull Class<?> requiredSender, @NonNull List<@NonNull CommandArgument<?, ?>> currentChain) {
        super(commandSender, currentChain);
        this.requiredSender = requiredSender;
    }

    public @NonNull Class<?> getRequiredSender() {
        return this.requiredSender;
    }

    @Override
    public String getMessage() {
        return String.format("%s is not allowed to execute that command. Must be of type %s", this.getCommandSender().getClass().getSimpleName(), this.requiredSender.getSimpleName());
    }
}

