/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.context;

import cloud.commandframework.CommandManager;
import cloud.commandframework.annotations.AnnotationAccessor;
import cloud.commandframework.annotations.injection.ParameterInjector;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.flags.FlagContext;
import cloud.commandframework.captions.Caption;
import cloud.commandframework.captions.CaptionRegistry;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.captions.CaptionVariableReplacementHandler;
import cloud.commandframework.captions.SimpleCaptionVariableReplacementHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CommandContext<C> {
    private final CaptionVariableReplacementHandler captionVariableReplacementHandler = new SimpleCaptionVariableReplacementHandler();
    private final Map<CommandArgument<C, ?>, ArgumentTiming> argumentTimings = new HashMap();
    private final FlagContext flagContext = FlagContext.create();
    private final Map<String, Object> internalStorage = new HashMap<String, Object>();
    private final C commandSender;
    private final boolean suggestions;
    private final CaptionRegistry<C> captionRegistry;
    private final CommandManager<C> commandManager;
    private CommandArgument<C, ?> currentArgument = null;

    @Deprecated
    public CommandContext(@NonNull C commandSender, @NonNull CaptionRegistry<C> captionRegistry) {
        this(false, commandSender, captionRegistry);
    }

    public CommandContext(@NonNull C commandSender, @NonNull CommandManager<C> commandManager) {
        this(false, commandSender, commandManager);
    }

    @Deprecated
    public CommandContext(boolean suggestions, @NonNull C commandSender, @NonNull CaptionRegistry<C> captionRegistry) {
        this.commandSender = commandSender;
        this.suggestions = suggestions;
        this.captionRegistry = captionRegistry;
        this.commandManager = null;
    }

    public CommandContext(boolean suggestions, @NonNull C commandSender, @NonNull CommandManager<C> commandManager) {
        this.commandSender = commandSender;
        this.suggestions = suggestions;
        this.commandManager = commandManager;
        this.captionRegistry = commandManager.getCaptionRegistry();
    }

    public @NonNull String formatMessage(@NonNull Caption caption, CaptionVariable ... variables) {
        return this.captionVariableReplacementHandler.replaceVariables(this.captionRegistry.getCaption(caption, this.commandSender), variables);
    }

    public @NonNull C getSender() {
        return this.commandSender;
    }

    public boolean isSuggestions() {
        return this.suggestions;
    }

    public <T> void store(@NonNull String key, @NonNull T value) {
        this.internalStorage.put(key, value);
    }

    public <T> void set(@NonNull String key, @Nullable T value) {
        if (value != null) {
            this.store(key, value);
        } else {
            this.remove(key);
        }
    }

    public boolean contains(@NonNull String key) {
        return this.internalStorage.containsKey(key);
    }

    public @NonNull Map<@NonNull String, @Nullable ?> asMap() {
        return Collections.unmodifiableMap(new HashMap<String, Object>(this.internalStorage));
    }

    public <T> @NonNull Optional<T> getOptional(@NonNull String key) {
        Object value = this.internalStorage.get(key);
        if (value != null) {
            Object castedValue = value;
            return Optional.of(castedValue);
        }
        return Optional.empty();
    }

    public <T> @NonNull Optional<T> getOptional(@NonNull CommandArgument<C, T> argument) {
        Object value = this.internalStorage.get(argument.getName());
        if (value != null) {
            Object castedValue = value;
            return Optional.of(castedValue);
        }
        return Optional.empty();
    }

    public void remove(@NonNull String key) {
        this.internalStorage.remove(key);
    }

    public <T> @NonNull T get(@NonNull String key) {
        Object value = this.internalStorage.get(key);
        if (value == null) {
            throw new NullPointerException("No such object stored in the context: " + key);
        }
        return (T)value;
    }

    public <T> @NonNull T get(@NonNull CommandArgument<C, T> argument) {
        return this.get(argument.getName());
    }

    public <T> @Nullable T getOrDefault(@NonNull CommandArgument<C, T> argument, @Nullable T defaultValue) {
        return this.getOptional(argument.getName()).orElse(defaultValue);
    }

    public <T> @Nullable T getOrDefault(@NonNull String key, @Nullable T defaultValue) {
        return this.getOptional(key).orElse(defaultValue);
    }

    public <T> @Nullable T getOrSupplyDefault(@NonNull String key, @NonNull Supplier<@Nullable T> defaultSupplier) {
        return this.getOptional(key).orElseGet(defaultSupplier);
    }

    public @NonNull LinkedList<@NonNull String> getRawInput() {
        return this.getOrDefault("__raw_input__", new LinkedList());
    }

    public @NonNull String getRawInputJoined() {
        return String.join((CharSequence)" ", this.getRawInput());
    }

    public @NonNull ArgumentTiming createTiming(@NonNull CommandArgument<C, ?> argument) {
        ArgumentTiming argumentTiming = new ArgumentTiming();
        this.argumentTimings.put(argument, argumentTiming);
        return argumentTiming;
    }

    public @NonNull Map<CommandArgument<@NonNull C, @NonNull ?>, ArgumentTiming> getArgumentTimings() {
        return Collections.unmodifiableMap(this.argumentTimings);
    }

    public @NonNull FlagContext flags() {
        return this.flagContext;
    }

    public @Nullable CommandArgument<C, ?> getCurrentArgument() {
        return this.currentArgument;
    }

    public void setCurrentArgument(@Nullable CommandArgument<C, ?> argument) {
        this.currentArgument = argument;
    }

    public <T> @NonNull Optional<T> inject(@NonNull Class<T> clazz) {
        if (this.commandManager == null) {
            throw new UnsupportedOperationException("Cannot retrieve injectable values from a command context that is not associated with a command manager");
        }
        for (ParameterInjector<C, ?> injector : this.commandManager.parameterInjectorRegistry().injectors(clazz)) {
            Object value = injector.create(this, AnnotationAccessor.empty());
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static final class ArgumentTiming {
        private long start;
        private long end;
        private boolean success;

        public ArgumentTiming(long start, long end, boolean success) {
            this.start = start;
            this.end = end;
            this.success = success;
        }

        public ArgumentTiming(long start) {
            this(start, -1L, false);
        }

        public ArgumentTiming() {
            this(-1L, -1L, false);
        }

        public long getElapsedTime() {
            if (this.end == -1L) {
                throw new IllegalStateException("No end time has been registered");
            }
            if (this.start == -1L) {
                throw new IllegalStateException("No start time has been registered");
            }
            return this.end - this.start;
        }

        public void setEnd(long end, boolean success) {
            this.end = end;
            this.success = success;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public boolean wasSuccess() {
            return this.success;
        }
    }
}

