/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.arguments.parser;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ArgumentParseResult<T> {
    private ArgumentParseResult() {
    }

    public static <T> @NonNull ArgumentParseResult<T> failure(@NonNull Throwable failure) {
        return new ParseFailure(failure);
    }

    public static <T> @NonNull ArgumentParseResult<T> success(@NonNull T value) {
        return new ParseSuccess(value);
    }

    public abstract @NonNull Optional<T> getParsedValue();

    public abstract @NonNull Optional<Throwable> getFailure();

    private static final class ParseFailure<T>
    extends ArgumentParseResult<T> {
        private final Throwable failure;

        private ParseFailure(@NonNull Throwable failure) {
            this.failure = failure;
        }

        @Override
        public @NonNull Optional<T> getParsedValue() {
            return Optional.empty();
        }

        @Override
        public @NonNull Optional<Throwable> getFailure() {
            return Optional.of(this.failure);
        }
    }

    private static final class ParseSuccess<T>
    extends ArgumentParseResult<T> {
        private final T value;

        private ParseSuccess(@NonNull T value) {
            this.value = value;
        }

        @Override
        public @NonNull Optional<T> getParsedValue() {
            return Optional.of(this.value);
        }

        @Override
        public @NonNull Optional<Throwable> getFailure() {
            return Optional.empty();
        }
    }
}

