/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.arguments.flags;

import cloud.commandframework.Description;
import cloud.commandframework.arguments.CommandArgument;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CommandFlag<T> {
    private final @NonNull String name;
    private final @NonNull String @NonNull [] aliases;
    private final @NonNull Description description;
    private final @Nullable CommandArgument<?, T> commandArgument;

    private CommandFlag(@NonNull String name, @NonNull String @NonNull [] aliases, @NonNull Description description, @Nullable CommandArgument<?, T> commandArgument) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.aliases = Objects.requireNonNull(aliases, "aliases cannot be null");
        this.description = Objects.requireNonNull(description, "description cannot be null");
        this.commandArgument = commandArgument;
    }

    public static @NonNull Builder<Void> newBuilder(@NonNull String name) {
        return new Builder<Void>(name);
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull Collection<@NonNull String> getAliases() {
        return Arrays.asList(this.aliases);
    }

    public @NonNull Description getDescription() {
        return this.description;
    }

    public @Nullable CommandArgument<?, T> getCommandArgument() {
        return this.commandArgument;
    }

    public String toString() {
        return String.format("--%s", this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandFlag that = (CommandFlag)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public static final class Builder<T> {
        private final String name;
        private final String[] aliases;
        private final Description description;
        private final CommandArgument<?, T> commandArgument;

        private Builder(@NonNull String name, @NonNull String[] aliases, @NonNull Description description, @Nullable CommandArgument<?, T> commandArgument) {
            this.name = name;
            this.aliases = aliases;
            this.description = description;
            this.commandArgument = commandArgument;
        }

        private Builder(@NonNull String name) {
            this(name, new String[0], Description.empty(), null);
        }

        public Builder<T> withAliases(String ... aliases) {
            HashSet<String> filteredAliases = new HashSet<String>();
            for (String alias : aliases) {
                if (alias.isEmpty()) continue;
                if (alias.length() > 1) {
                    throw new IllegalArgumentException(String.format("Alias '%s' has name longer than one character. This is not allowed", alias));
                }
                filteredAliases.add(alias);
            }
            return new Builder<T>(this.name, filteredAliases.toArray(new String[0]), this.description, this.commandArgument);
        }

        public Builder<T> withDescription(@NonNull Description description) {
            return new Builder<T>(this.name, this.aliases, description, this.commandArgument);
        }

        public <N> Builder<N> withArgument(@NonNull CommandArgument<?, N> argument) {
            return new Builder<N>(this.name, this.aliases, this.description, argument);
        }

        public <N> Builder<N> withArgument(@NonNull CommandArgument.Builder<?, N> builder) {
            return this.withArgument(builder.build());
        }

        public @NonNull CommandFlag<T> build() {
            return new CommandFlag(this.name, this.aliases, this.description, this.commandArgument);
        }
    }
}

