/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.meta;

import cloud.commandframework.meta.CommandMeta;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SimpleCommandMeta
extends CommandMeta {
    private final Map<String, String> metaMap;

    protected SimpleCommandMeta(@NonNull Map<@NonNull String, @NonNull String> metaMap) {
        this.metaMap = Collections.unmodifiableMap(metaMap);
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull SimpleCommandMeta empty() {
        return SimpleCommandMeta.builder().build();
    }

    @Override
    public final @NonNull Optional<String> getValue(@NonNull String key) {
        return Optional.ofNullable(this.metaMap.get(key));
    }

    @Override
    public final @NonNull String getOrDefault(@NonNull String key, @NonNull String defaultValue) {
        return this.getValue(key).orElse(defaultValue);
    }

    @Override
    public final @NonNull Map<@NonNull String, @NonNull String> getAll() {
        return new HashMap<String, String>(this.metaMap);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleCommandMeta that = (SimpleCommandMeta)o;
        return Objects.equals(this.metaMap, that.metaMap);
    }

    public final int hashCode() {
        return Objects.hashCode(this.metaMap);
    }

    public static final class Builder {
        private final Map<String, String> map = new HashMap<String, String>();

        private Builder() {
        }

        public @NonNull Builder with(@NonNull CommandMeta commandMeta) {
            commandMeta.getAll().forEach(this::with);
            return this;
        }

        public @NonNull Builder with(@NonNull String key, @NonNull String value) {
            this.map.put(key, value);
            return this;
        }

        public @NonNull SimpleCommandMeta build() {
            return new SimpleCommandMeta(this.map);
        }
    }
}

