/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.extra.confirmation;

import cloud.commandframework.CommandManager;
import cloud.commandframework.execution.CommandExecutionHandler;
import cloud.commandframework.execution.postprocessor.CommandPostprocessingContext;
import cloud.commandframework.execution.postprocessor.CommandPostprocessor;
import cloud.commandframework.meta.SimpleCommandMeta;
import cloud.commandframework.services.types.ConsumerService;
import cloud.commandframework.types.tuples.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CommandConfirmationManager<C> {
    public static final String CONFIRMATION_REQUIRED_META = "__REQUIRE_CONFIRMATION__";
    private static final int MAXIMUM_PENDING_SIZE = 100;
    private final Consumer<CommandPostprocessingContext<C>> notifier;
    private final Consumer<C> errorNotifier;
    private final Map<C, Pair<CommandPostprocessingContext<C>, Long>> pendingCommands;
    private final long timeoutMillis;

    public CommandConfirmationManager(long timeout, @NonNull TimeUnit timeoutTimeUnit, @NonNull Consumer<@NonNull CommandPostprocessingContext<C>> notifier, @NonNull Consumer<@NonNull C> errorNotifier) {
        this.notifier = notifier;
        this.errorNotifier = errorNotifier;
        this.pendingCommands = new LinkedHashMap<C, Pair<CommandPostprocessingContext<C>, Long>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<C, Pair<CommandPostprocessingContext<C>, Long>> eldest) {
                return this.size() > 100;
            }
        };
        this.timeoutMillis = timeoutTimeUnit.toMillis(timeout);
    }

    private void notifyConsumer(@NonNull CommandPostprocessingContext<C> context) {
        this.notifier.accept(context);
    }

    private void addPending(@NonNull CommandPostprocessingContext<C> context) {
        this.pendingCommands.put(context.getCommandContext().getSender(), Pair.of(context, System.currentTimeMillis()));
    }

    public @NonNull Optional<CommandPostprocessingContext<C>> getPending(@NonNull C sender) {
        Pair<CommandPostprocessingContext<C>, Long> pair = this.pendingCommands.remove(sender);
        if (pair != null && System.currentTimeMillis() < pair.getSecond() + this.timeoutMillis) {
            return Optional.of(pair.getFirst());
        }
        return Optional.empty();
    }

    public @NonNull SimpleCommandMeta.Builder decorate(@NonNull SimpleCommandMeta.Builder builder) {
        return builder.with(CONFIRMATION_REQUIRED_META, "true");
    }

    public void registerConfirmationProcessor(@NonNull CommandManager<C> manager) {
        manager.registerCommandPostProcessor(new CommandConfirmationPostProcessor());
    }

    public @NonNull CommandExecutionHandler<C> createConfirmationExecutionHandler() {
        return context -> {
            Optional pending = this.getPending(context.getSender());
            if (pending.isPresent()) {
                CommandPostprocessingContext postprocessingContext = pending.get();
                postprocessingContext.getCommand().getCommandExecutionHandler().execute(postprocessingContext.getCommandContext());
            } else {
                this.errorNotifier.accept(context.getSender());
            }
        };
    }

    private final class CommandConfirmationPostProcessor
    implements CommandPostprocessor<C> {
        private CommandConfirmationPostProcessor() {
        }

        public void accept(@NonNull CommandPostprocessingContext<C> context) {
            if (!context.getCommand().getCommandMeta().getOrDefault(CommandConfirmationManager.CONFIRMATION_REQUIRED_META, "false").equals("true")) {
                return;
            }
            CommandConfirmationManager.this.addPending(context);
            CommandConfirmationManager.this.notifyConsumer(context);
            ConsumerService.interrupt();
        }
    }
}

