/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.execution;

import cloud.commandframework.Command;
import cloud.commandframework.CommandTree;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.execution.CommandResult;
import cloud.commandframework.services.State;
import cloud.commandframework.types.tuples.Pair;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class CommandExecutionCoordinator<C> {
    private final CommandTree<C> commandTree;

    protected CommandExecutionCoordinator(@NonNull CommandTree<C> commandTree) {
        this.commandTree = commandTree;
    }

    public static <C> @NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> simpleCoordinator() {
        return x$0 -> new SimpleCoordinator((CommandTree)x$0);
    }

    public abstract @NonNull CompletableFuture<CommandResult<C>> coordinateExecution(@NonNull CommandContext<C> var1, @NonNull Queue<@NonNull String> var2);

    protected @NonNull CommandTree<C> getCommandTree() {
        return this.commandTree;
    }

    public static final class SimpleCoordinator<C>
    extends CommandExecutionCoordinator<C> {
        private SimpleCoordinator(@NonNull CommandTree<C> commandTree) {
            super(commandTree);
        }

        @Override
        public CompletableFuture<CommandResult<C>> coordinateExecution(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> input) {
            CompletableFuture<CommandResult<C>> completableFuture = new CompletableFuture<CommandResult<C>>();
            try {
                @NonNull Pair<@Nullable Command<C>, @Nullable Exception> pair = this.getCommandTree().parse(commandContext, input);
                if (pair.getSecond() != null) {
                    completableFuture.completeExceptionally(pair.getSecond());
                } else {
                    Command command = Objects.requireNonNull(pair.getFirst());
                    if (this.getCommandTree().getCommandManager().postprocessContext(commandContext, command) == State.ACCEPTED) {
                        command.getCommandExecutionHandler().execute(commandContext);
                    }
                    completableFuture.complete(new CommandResult<C>(commandContext));
                }
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
            }
            return completableFuture;
        }
    }
}

