/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.execution;

import cloud.commandframework.Command;
import cloud.commandframework.CommandManager;
import cloud.commandframework.CommandTree;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.execution.CommandExecutionCoordinator;
import cloud.commandframework.execution.CommandResult;
import cloud.commandframework.services.State;
import cloud.commandframework.types.tuples.Pair;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class AsynchronousCommandExecutionCoordinator<C>
extends CommandExecutionCoordinator<C> {
    private final CommandManager<C> commandManager;
    private final Executor executor;
    private final boolean synchronizeParsing;

    private AsynchronousCommandExecutionCoordinator(@Nullable Executor executor, boolean synchronizeParsing, @NonNull CommandTree<C> commandTree) {
        super(commandTree);
        this.executor = executor == null ? ForkJoinPool.commonPool() : executor;
        this.synchronizeParsing = synchronizeParsing;
        this.commandManager = commandTree.getCommandManager();
    }

    public static <C> @NonNull Builder<C> newBuilder() {
        return new Builder();
    }

    @Override
    public @NonNull CompletableFuture<CommandResult<C>> coordinateExecution(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> input) {
        Consumer<Command> commandConsumer = command -> {
            if (this.commandManager.postprocessContext(commandContext, (Command<C>)command) == State.ACCEPTED) {
                command.getCommandExecutionHandler().execute(commandContext);
            }
        };
        if (this.synchronizeParsing) {
            @NonNull Pair<@Nullable Command<C>, @Nullable Exception> pair = this.getCommandTree().parse(commandContext, input);
            if (pair.getSecond() != null) {
                CompletableFuture<CommandResult<C>> future = new CompletableFuture<CommandResult<C>>();
                future.completeExceptionally(pair.getSecond());
                return future;
            }
            return CompletableFuture.supplyAsync(() -> {
                commandConsumer.accept((Command)pair.getFirst());
                return new CommandResult(commandContext);
            }, this.executor);
        }
        CompletableFuture<CommandResult<C>> resultFuture = new CompletableFuture<CommandResult<C>>();
        this.executor.execute(() -> {
            try {
                @NonNull Pair<@Nullable Command<C>, @Nullable Exception> pair = this.getCommandTree().parse(commandContext, input);
                if (pair.getSecond() != null) {
                    resultFuture.completeExceptionally(pair.getSecond());
                } else {
                    commandConsumer.accept(pair.getFirst());
                    resultFuture.complete(new CommandResult(commandContext));
                }
            }
            catch (Exception e) {
                resultFuture.completeExceptionally(e);
            }
        });
        return resultFuture;
    }

    public static final class Builder<C> {
        private Executor executor = null;
        private boolean synchronizeParsing = false;

        private Builder() {
        }

        public @NonNull Builder<C> withSynchronousParsing() {
            this.synchronizeParsing = true;
            return this;
        }

        public @NonNull Builder<C> withAsynchronousParsing() {
            this.synchronizeParsing = false;
            return this;
        }

        public @NonNull Builder<C> withExecutor(@NonNull Executor executor) {
            this.executor = executor;
            return this;
        }

        public @NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> build() {
            return tree -> new AsynchronousCommandExecutionCoordinator(this.executor, this.synchronizeParsing, (CommandTree)tree);
        }
    }
}

