/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework;

import cloud.commandframework.Command;
import cloud.commandframework.CommandManager;
import cloud.commandframework.CommandTree;
import cloud.commandframework.execution.CommandExecutionCoordinator;
import cloud.commandframework.internal.CommandRegistrationHandler;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class LockableCommandManager<C>
extends CommandManager<C> {
    private final Object writeLock = new Object();
    private volatile boolean writeLocked = false;

    protected LockableCommandManager(@NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> commandExecutionCoordinator, @NonNull CommandRegistrationHandler commandRegistrationHandler) {
        super(commandExecutionCoordinator, commandRegistrationHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final @NonNull CommandManager<C> command(@NonNull Command<C> command) {
        Object object = this.writeLock;
        synchronized (object) {
            if (!this.isCommandRegistrationAllowed()) {
                throw new IllegalStateException("Command registration is not allowed. The command manager has been locked.");
            }
            return super.command(command);
        }
    }

    @Override
    public final @NonNull CommandManager<C> command(@NonNull Command.Builder<C> command) {
        return super.command(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void lockWrites() {
        Object object = this.writeLock;
        synchronized (object) {
            this.writeLocked = true;
        }
    }

    public final boolean isCommandRegistrationAllowed() {
        return !this.writeLocked;
    }
}

